/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.security.spring.config;

import cn.sliew.carp.framework.common.security.annotations.AnonymousAccess;
import cn.sliew.carp.framework.web.util.RequestParamUtil;
import cn.sliew.carp.framework.web.util.SpringContextUtil;
import cn.sliew.carp.module.security.spring.authentication.CarpAccessDeniedHandler;
import cn.sliew.carp.module.security.spring.authentication.CarpAuthenticationEntryPoint;
import cn.sliew.carp.module.security.spring.authentication.CarpPasswordEncoder;
import cn.sliew.carp.module.security.spring.config.CarpTokenConfigurer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.security.servlet.EndpointRequest;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.SecurityConfigurer;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true)
public class CarpSecurityConfig {
    @Autowired
    private CarpTokenConfigurer carpTokenConfigurer;
    @Autowired
    private CarpAuthenticationEntryPoint carpAuthenticationEntryPoint;
    @Autowired
    private CarpAccessDeniedHandler carpAccessDeniedHandler;

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        http.csrf(this::csrf);
        http.headers(this::headers);
        http.formLogin(this::formLogin);
        http.apply((SecurityConfigurer)this.carpTokenConfigurer);
        http.authorizeHttpRequests(this::authorizeRequests);
        http.sessionManagement(this::sessionManagement);
        http.exceptionHandling(this::exceptionHandling);
        return (SecurityFilterChain)http.build();
    }

    private void csrf(CsrfConfigurer<HttpSecurity> csrf) {
        csrf.disable();
    }

    private void headers(HeadersConfigurer<HttpSecurity> headers) {
        headers.frameOptions(frameOptions -> frameOptions.disable());
    }

    private void formLogin(FormLoginConfigurer<HttpSecurity> formLogin) {
        formLogin.disable();
    }

    private void authorizeRequests(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizeHttpRequests) {
        ApplicationContext applicationContext = SpringContextUtil.getApplicationContext();
        Map handlerMethodMap = ((RequestMappingHandlerMapping)applicationContext.getBean("requestMappingHandlerMapping", RequestMappingHandlerMapping.class)).getHandlerMethods();
        HashSet anonymousUrls = new HashSet();
        for (Map.Entry entry : handlerMethodMap.entrySet()) {
            RequestMappingInfo requestMappingInfo = (RequestMappingInfo)entry.getKey();
            HandlerMethod handlerMethod = (HandlerMethod)entry.getValue();
            if (!handlerMethod.getBeanType().isAnnotationPresent(AnonymousAccess.class) && !handlerMethod.hasMethodAnnotation(AnonymousAccess.class)) continue;
            AnonymousAccess anonymousAccess = handlerMethod.getBeanType().getAnnotation(AnonymousAccess.class);
            if (anonymousAccess == null) {
                anonymousAccess = (AnonymousAccess)handlerMethod.getMethodAnnotation(AnonymousAccess.class);
            }
            anonymousUrls.addAll(requestMappingInfo.getPatternValues());
        }
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizeHttpRequests.requestMatchers(anonymousUrls.toArray(new String[0]))).permitAll();
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizeHttpRequests.requestMatchers(new RequestMatcher[]{EndpointRequest.toAnyEndpoint()})).permitAll();
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizeHttpRequests.requestMatchers(HttpMethod.GET, new String[]{"/**/*.css", "/**/*.js", "/**/*.png", "/**/*.woff", "/**/*.woff2", "/**/*.svg", "/**/*.json", "/**/*.ttf", "/**/*.ico", "/index.html"})).permitAll();
        String[] ignorePaths = (String[])RequestParamUtil.getDefaultIgnorePaths().stream().toArray(String[]::new);
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizeHttpRequests.requestMatchers(ignorePaths)).permitAll();
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizeHttpRequests.requestMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).permitAll();
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizeHttpRequests.anyRequest()).authenticated();
    }

    private void sessionManagement(SessionManagementConfigurer<HttpSecurity> sessionManagement) {
        sessionManagement.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }

    private void exceptionHandling(ExceptionHandlingConfigurer<HttpSecurity> exceptionHandling) {
        exceptionHandling.authenticationEntryPoint((AuthenticationEntryPoint)this.carpAuthenticationEntryPoint).accessDeniedHandler((AccessDeniedHandler)this.carpAccessDeniedHandler);
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new CarpPasswordEncoder();
    }

    @Bean
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        config.addAllowedOriginPattern("*");
        config.setAllowedHeaders(Arrays.asList("Origin", "Content-Type", "Accept", "responseType", "u_token"));
        config.setAllowedMethods(Arrays.asList("GET", "POST", "PUT", "OPTIONS", "DELETE", "PATCH"));
        source.registerCorsConfiguration("/**", config);
        return new CorsFilter((CorsConfigurationSource)source);
    }
}

