/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.util;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.http.impl.util.ExposeAttributes;
import org.apache.pekko.http.impl.util.StreamUtils;
import org.apache.pekko.http.impl.util.StreamUtils$;
import org.apache.pekko.http.impl.util.StreamUtils$$anon$4$;
import org.apache.pekko.http.impl.util.StreamUtils$$anon$8$$anon$9$DeliveringData$;
import org.apache.pekko.http.impl.util.StreamUtils$$anon$8$$anon$9$WaitingForData$;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.util.FastFuture$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.IOResult;
import org.apache.pekko.stream.KillSwitch;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Shape;
import org.apache.pekko.stream.impl.fusing.GraphInterpreter$;
import org.apache.pekko.stream.impl.fusing.GraphStages;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.stage.AsyncCallback;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@InternalApi
public final class StreamUtils$ {
    public static StreamUtils$ MODULE$;
    private final Source<Nothing$, NotUsed> EmptySource;
    private final Materializer OnlyRunInGraphInterpreterContext;
    private final Future<BoxedUnit> org$apache$pekko$http$impl$util$StreamUtils$$successfulDone;

    static {
        new StreamUtils$();
    }

    public GraphStage<FlowShape<ByteString, ByteString>> byteStringTransformer(Function1<ByteString, ByteString> f, Function0<ByteString> finish) {
        return new GraphStages.SimpleLinearGraphStage<ByteString>(f, finish){
            public final Function1 f$1;
            public final Function0 finish$1;

            public GraphStageLogic createLogic(Attributes inheritedAttributes) {
                return new InHandler(this){
                    private final /* synthetic */ anon.1 $outer;

                    public void onDownstreamFinish() throws Exception {
                        OutHandler.onDownstreamFinish$((OutHandler)this);
                    }

                    public void onDownstreamFinish(Throwable cause) throws Exception {
                        OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
                    }

                    public void onUpstreamFailure(Throwable ex) throws Exception {
                        InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                    }

                    public void onPush() {
                        ByteString data = (ByteString)this.$outer.f$1.apply(this.grab(this.$outer.in()));
                        if (data.nonEmpty()) {
                            this.push(this.$outer.out(), data);
                            return;
                        }
                        this.pull(this.$outer.in());
                    }

                    public void onPull() {
                        this.pull(this.$outer.in());
                    }

                    public void onUpstreamFinish() {
                        ByteString data = (ByteString)this.$outer.finish$1.apply();
                        if (data.nonEmpty()) {
                            this.emit(this.$outer.out(), data);
                        }
                        this.completeStage();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super((Shape)$outer.shape());
                        InHandler.$init$((InHandler)this);
                        OutHandler.$init$((OutHandler)this);
                        this.setHandlers($outer.in(), $outer.out(), this);
                    }
                };
            }
            {
                this.f$1 = f$1;
                this.finish$1 = finish$1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public <T, Mat> Tuple2<Source<T, Mat>, Future<BoxedUnit>> captureTermination(Source<T, Mat> source) {
        void var4_4;
        void var3_3;
        Tuple4<Source<T, Mat>, Future<BoxedUnit>, Future<BoxedUnit>, KillSwitch> tuple4 = this.captureMaterializationTerminationAndKillSwitch(source);
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        Source newSource = (Source)tuple4._1();
        Future termination = (Future)tuple4._2();
        void newSource2 = var3_3;
        void termination2 = var4_4;
        return new Tuple2((Object)newSource2, (Object)termination2);
    }

    public <T, Mat> Tuple4<Source<T, Mat>, Future<BoxedUnit>, Future<BoxedUnit>, KillSwitch> captureMaterializationTerminationAndKillSwitch(Source<T, Mat> source) {
        Promise terminationPromise = Promise$.MODULE$.apply();
        Promise materializationPromise = Promise$.MODULE$.apply();
        Promise killResult = Promise$.MODULE$.apply();
        KillSwitch killSwitch = new KillSwitch(killResult){
            private final Promise killResult$1;

            public void shutdown() {
                this.killResult$1.trySuccess((Object)BoxedUnit.UNIT);
            }

            public void abort(Throwable ex) {
                this.killResult$1.tryFailure(ex);
            }
            {
                this.killResult$1 = killResult$1;
            }
        };
        GraphStages.SimpleLinearGraphStage transformer = new GraphStages.SimpleLinearGraphStage<T>(materializationPromise, killResult, terminationPromise){
            public final Promise materializationPromise$1;
            public final Promise killResult$1;
            public final Promise terminationPromise$1;

            public GraphStageLogic createLogic(Attributes inheritedAttributes) {
                return new InHandler(this){
                    private final AsyncCallback<Try<BoxedUnit>> killCallback;
                    private final /* synthetic */ anon.4 $outer;

                    public void onDownstreamFinish() throws Exception {
                        OutHandler.onDownstreamFinish$((OutHandler)this);
                    }

                    public void onDownstreamFinish(Throwable cause) throws Exception {
                        OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
                    }

                    public void onUpstreamFinish() throws Exception {
                        InHandler.onUpstreamFinish$((InHandler)this);
                    }

                    public void preStart() {
                        this.$outer.materializationPromise$1.trySuccess((Object)BoxedUnit.UNIT);
                        Option option = this.$outer.killResult$1.future().value();
                        if (option instanceof Some) {
                            Try res = (Try)((Some)option).value();
                            this.handleKill((Try<BoxedUnit>)res);
                            return;
                        }
                        if (None$.MODULE$.equals(option)) {
                            this.$outer.killResult$1.future().onComplete((Function1 & Serializable & scala.Serializable)t -> {
                                anon$4$$anon$5.$anonfun$preStart$1(this, t);
                                return BoxedUnit.UNIT;
                            }, ExecutionContexts$.MODULE$.parasitic());
                            return;
                        }
                        throw new MatchError((Object)option);
                    }

                    public void onPush() {
                        this.push(this.$outer.out(), this.grab(this.$outer.in()));
                    }

                    public void onPull() {
                        this.pull(this.$outer.in());
                    }

                    public void onUpstreamFailure(Throwable ex) {
                        this.$outer.terminationPromise$1.tryFailure(ex);
                        this.failStage(ex);
                    }

                    public void postStop() {
                        this.$outer.terminationPromise$1.trySuccess((Object)BoxedUnit.UNIT);
                    }

                    private void handleKill(Try<BoxedUnit> result) {
                        if (result instanceof Success) {
                            this.completeStage();
                            return;
                        }
                        if (result instanceof Failure) {
                            Throwable ex = ((Failure)result).exception();
                            this.failStage(ex);
                            return;
                        }
                        throw new MatchError(result);
                    }

                    public static final /* synthetic */ void $anonfun$preStart$1(anon$4$$anon$5 $this, Try t) {
                        $this.killCallback.invoke((Object)t);
                    }

                    public static final /* synthetic */ void $anonfun$killCallback$1(anon$4$$anon$5 $this, Try result) {
                        $this.handleKill((Try<BoxedUnit>)result);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super((Shape)$outer.shape());
                        InHandler.$init$((InHandler)this);
                        OutHandler.$init$((OutHandler)this);
                        this.setHandlers($outer.in(), $outer.out(), this);
                        this.killCallback = this.getAsyncCallback((Function1 & Serializable & scala.Serializable)result -> {
                            anon$4$$anon$5.$anonfun$killCallback$1(this, result);
                            return BoxedUnit.UNIT;
                        });
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$preStart$1$adapted(org.apache.pekko.http.impl.util.StreamUtils$$anon$4$$anon$5 scala.util.Try ), $anonfun$killCallback$1$adapted(org.apache.pekko.http.impl.util.StreamUtils$$anon$4$$anon$5 scala.util.Try )}, serializedLambda);
                    }
                };
            }
            {
                this.materializationPromise$1 = materializationPromise$1;
                this.killResult$1 = killResult$1;
                this.terminationPromise$1 = terminationPromise$1;
            }
        };
        return new Tuple4((Object)source.via((Graph)transformer), (Object)terminationPromise.future(), (Object)materializationPromise.future(), (Object)killSwitch);
    }

    public Flow<ByteString, ByteString, NotUsed> sliceBytesTransformer(long start, long length) {
        GraphStages.SimpleLinearGraphStage<ByteString> transformer = new GraphStages.SimpleLinearGraphStage<ByteString>(start, length){
            public final long start$1;
            public final long length$1;

            public GraphStageLogic createLogic(Attributes inheritedAttributes) {
                return new InHandler(this){
                    private long toSkip;
                    private long remaining;
                    private final /* synthetic */ anon.6 $outer;

                    public void onDownstreamFinish() throws Exception {
                        OutHandler.onDownstreamFinish$((OutHandler)this);
                    }

                    public void onDownstreamFinish(Throwable cause) throws Exception {
                        OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
                    }

                    public void onUpstreamFinish() throws Exception {
                        InHandler.onUpstreamFinish$((InHandler)this);
                    }

                    public void onUpstreamFailure(Throwable ex) throws Exception {
                        InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                    }

                    public void onPull() {
                        this.pull(this.$outer.in());
                    }

                    private long toSkip() {
                        return this.toSkip;
                    }

                    private void toSkip_$eq(long x$1) {
                        this.toSkip = x$1;
                    }

                    private long remaining() {
                        return this.remaining;
                    }

                    private void remaining_$eq(long x$1) {
                        this.remaining = x$1;
                    }

                    public void onPush() {
                        ByteString element = (ByteString)this.grab(this.$outer.in());
                        if (this.toSkip() >= (long)element.length()) {
                            this.pull(this.$outer.in());
                        } else {
                            ByteString data = element.drop((int)this.toSkip()).take((int)package$.MODULE$.min(this.remaining(), Integer.MAX_VALUE));
                            this.remaining_$eq(this.remaining() - (long)data.size());
                            this.push(this.$outer.out(), data);
                            if (this.remaining() <= 0L) {
                                this.completeStage();
                            }
                        }
                        if (this.toSkip() > 0L) {
                            this.toSkip_$eq(this.toSkip() - (long)element.length());
                            return;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super((Shape)$outer.shape());
                        InHandler.$init$((InHandler)this);
                        OutHandler.$init$((OutHandler)this);
                        this.toSkip = $outer.start$1;
                        this.remaining = $outer.length$1;
                        this.setHandlers($outer.in(), $outer.out(), this);
                    }
                };
            }
            {
                this.start$1 = start$1;
                this.length$1 = length$1;
            }
        };
        return Flow$.MODULE$.apply().via((Graph)transformer).named("sliceBytes");
    }

    public GraphStage<FlowShape<ByteString, ByteString>> limitByteChunksStage(int maxBytesPerChunk) {
        return new GraphStages.SimpleLinearGraphStage<ByteString>(maxBytesPerChunk){
            public final int maxBytesPerChunk$1;

            public Attributes initialAttributes() {
                return Attributes$.MODULE$.name("limitByteChunksStage");
            }

            public GraphStageLogic createLogic(Attributes inheritedAttributes) {
                return new GraphStageLogic(this){
                    private volatile StreamUtils$$anon$8$$anon$9$WaitingForData$ WaitingForData$module;
                    private volatile StreamUtils$$anon$8$$anon$9$DeliveringData$ DeliveringData$module;
                    private ByteString org$apache$pekko$http$impl$util$StreamUtils$$anon$$anon$$remaining;
                    private final /* synthetic */ anon.8 $outer;

                    public StreamUtils$$anon$8$$anon$9$WaitingForData$ org$apache$pekko$http$impl$util$StreamUtils$$anon$$anon$$WaitingForData() {
                        if (this.WaitingForData$module == null) {
                            this.WaitingForData$lzycompute$1();
                        }
                        return this.WaitingForData$module;
                    }

                    public StreamUtils$$anon$8$$anon$9$DeliveringData$ org$apache$pekko$http$impl$util$StreamUtils$$anon$$anon$$DeliveringData() {
                        if (this.DeliveringData$module == null) {
                            this.DeliveringData$lzycompute$1();
                        }
                        return this.DeliveringData$module;
                    }

                    public ByteString org$apache$pekko$http$impl$util$StreamUtils$$anon$$anon$$remaining() {
                        return this.org$apache$pekko$http$impl$util$StreamUtils$$anon$$anon$$remaining;
                    }

                    private void org$apache$pekko$http$impl$util$StreamUtils$$anon$$anon$$remaining_$eq(ByteString x$1) {
                        this.org$apache$pekko$http$impl$util$StreamUtils$$anon$$anon$$remaining = x$1;
                    }

                    public void org$apache$pekko$http$impl$util$StreamUtils$$anon$$anon$$splitAndPush(ByteString data) {
                        ByteString toPush = data.take(this.$outer.maxBytesPerChunk$1);
                        ByteString toKeep = data.drop(this.$outer.maxBytesPerChunk$1);
                        this.push(this.$outer.out(), toPush);
                        this.org$apache$pekko$http$impl$util$StreamUtils$$anon$$anon$$remaining_$eq(toKeep);
                    }

                    public String toString() {
                        return "limitByteChunksStage";
                    }

                    public /* synthetic */ anon.8 org$apache$pekko$http$impl$util$StreamUtils$$anon$$anon$$$outer() {
                        return this.$outer;
                    }

                    private final void WaitingForData$lzycompute$1() {
                        synchronized (this) {
                            if (this.WaitingForData$module == null) {
                                this.WaitingForData$module = new StreamUtils$$anon$8$$anon$9$WaitingForData$(this);
                            }
                            return;
                        }
                    }

                    private final void DeliveringData$lzycompute$1() {
                        synchronized (this) {
                            if (this.DeliveringData$module == null) {
                                this.DeliveringData$module = new StreamUtils$$anon$8$$anon$9$DeliveringData$(this);
                            }
                            return;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super((Shape)$outer.shape());
                        this.org$apache$pekko$http$impl$util$StreamUtils$$anon$$anon$$remaining = ByteString$.MODULE$.empty();
                        this.setHandlers($outer.in(), $outer.out(), this.org$apache$pekko$http$impl$util$StreamUtils$$anon$$anon$$WaitingForData());
                    }
                };
            }
            {
                this.maxBytesPerChunk$1 = maxBytesPerChunk$1;
            }
        };
    }

    public <T> Flow<T, T, NotUsed> delayCancellation(Duration cancelAfter) {
        return Flow$.MODULE$.fromGraph(new StreamUtils.DelayCancellationStage(cancelAfter));
    }

    public <T, U> Flow<T, U, NotUsed> statefulAttrsMap(Function1<Attributes, Function1<T, U>> functionConstructor) {
        return Flow$.MODULE$.apply().via(new ExposeAttributes<T, U>(functionConstructor));
    }

    private Source<Nothing$, NotUsed> EmptySource() {
        return this.EmptySource;
    }

    public Materializer OnlyRunInGraphInterpreterContext() {
        return this.OnlyRunInGraphInterpreterContext;
    }

    /*
     * Unable to fully structure code
     */
    public void cancelSource(Source<?, ?> source, Materializer materializer) {
        v0 = this.EmptySource();
        if (!(v0 != null ? v0.equals(source) == false : source != null)) {
            return;
        }
        var4_3 = false;
        var5_4 = GraphInterpreter$.MODULE$.currentInterpreterOrNull();
        if (var5_4 != null) ** GOTO lbl-1000
        var4_3 = true;
        if (materializer != null) {
            v1 = materializer;
        } else lbl-1000:
        // 2 sources

        {
            if (var4_3) {
                throw new IllegalStateException("Need to pass materializer to cancelSource if not run from GraphInterpreter context.");
            }
            v1 = var5_4.subFusingMaterializer();
        }
        mat = v1;
        source.runWith((Graph)Sink$.MODULE$.ignore(), mat);
    }

    public Future<BoxedUnit> org$apache$pekko$http$impl$util$StreamUtils$$successfulDone() {
        return this.org$apache$pekko$http$impl$util$StreamUtils$$successfulDone;
    }

    /*
     * WARNING - void declaration
     */
    public <T extends HttpEntity, M> Tuple2<T, M> transformEntityStream(T entity, StreamUtils.EntityStreamOp<M> streamOp) {
        if (entity instanceof HttpEntity.Strict) {
            HttpEntity.Strict strict = (HttpEntity.Strict)entity;
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)strict), streamOp.strictM());
        }
        if (entity instanceof HttpEntity.Default) {
            void var7_7;
            void var6_6;
            HttpEntity.Default default_ = (HttpEntity.Default)entity;
            Tuple2<Source<ByteString, Object>, M> tuple2 = streamOp.apply(default_.data());
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Source newData = (Source)tuple2._1();
            Object whenCompleted = tuple2._2();
            void newData2 = var6_6;
            ContentType x$2 = default_.copy$default$1();
            long x$3 = default_.copy$default$2();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)default_.copy(x$2, x$3, (Source<ByteString, Object>)newData2)), (Object)var7_7);
        }
        if (entity instanceof HttpEntity.Chunked) {
            void var15_14;
            void var14_13;
            HttpEntity.Chunked chunked = (HttpEntity.Chunked)entity;
            Tuple2<Source<HttpEntity.ChunkStreamPart, Object>, M> tuple2 = streamOp.apply(chunked.chunks());
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Source newChunks = (Source)tuple2._1();
            Object whenCompleted = tuple2._2();
            void newChunks2 = var14_13;
            ContentType x$5 = chunked.copy$default$1();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)chunked.copy(x$5, (Source<HttpEntity.ChunkStreamPart, Object>)newChunks2)), (Object)var15_14);
        }
        if (entity instanceof HttpEntity.CloseDelimited) {
            void var21_20;
            void var20_19;
            HttpEntity.CloseDelimited closeDelimited = (HttpEntity.CloseDelimited)entity;
            Tuple2<Source<ByteString, Object>, M> tuple2 = streamOp.apply(closeDelimited.data());
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Source newData = (Source)tuple2._1();
            Object whenCompleted = tuple2._2();
            void newData3 = var20_19;
            ContentType x$7 = closeDelimited.copy$default$1();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)closeDelimited.copy(x$7, (Source<ByteString, Object>)newData3)), (Object)var21_20);
        }
        if (entity instanceof HttpEntity.IndefiniteLength) {
            void var27_26;
            void var26_25;
            HttpEntity.IndefiniteLength indefiniteLength = (HttpEntity.IndefiniteLength)entity;
            Tuple2<Source<ByteString, Object>, M> tuple2 = streamOp.apply(indefiniteLength.data());
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Source newData = (Source)tuple2._1();
            Object whenCompleted = tuple2._2();
            void newData4 = var26_25;
            ContentType x$9 = indefiniteLength.copy$default$1();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indefiniteLength.copy(x$9, (Source<ByteString, Object>)newData4)), (Object)var27_26);
        }
        throw new MatchError(entity);
    }

    public Future<IOResult> handleIOResult(IOResult ioResult) {
        if (ioResult.wasSuccessful()) {
            return (Future)FastFuture$.MODULE$.successful().apply((Object)ioResult);
        }
        return (Future)FastFuture$.MODULE$.failed().apply((Object)ioResult.getError());
    }

    public <T> Flow<T, T, NotUsed> encodeErrorAndComplete(Function1<Throwable, T> f) {
        return (Flow)Flow$.MODULE$.apply().recoverWithRetries(1, (PartialFunction)new scala.Serializable(f){
            public static final long serialVersionUID = 0L;
            private final Function1 f$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    try {
                        return (B1)Source$.MODULE$.single(this.f$2.apply(x1));
                    }
                    catch (Throwable throwable) {
                        Option option = NonFatal$.MODULE$.unapply(throwable);
                        if (!option.isEmpty()) {
                            Throwable ex = (Throwable)option.get();
                            return (B1)Source$.MODULE$.failed(ex);
                        }
                        throw throwable;
                    }
                }
                return (B1)function1.apply(null);
            }

            public final boolean isDefinedAt(Throwable x1) {
                return x1 != null;
            }
            {
                this.f$2 = f$2;
            }
        });
    }

    private StreamUtils$() {
        MODULE$ = this;
        this.EmptySource = Source$.MODULE$.empty();
        this.OnlyRunInGraphInterpreterContext = null;
        this.org$apache$pekko$http$impl$util$StreamUtils$$successfulDone = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }
}

