create database if not exists ageiport default character set utf8mb4 collate utf8mb4_unicode_ci;
use ageiport;

CREATE TABLE `agei_main_task_instance`
(
    `id`                   bigint      NOT NULL AUTO_INCREMENT,
    `app`                  varchar(64) NOT NULL,
    `biz_key`              varchar(64)   DEFAULT NULL,
    `biz_query`            text,
    `biz_task_name`        varchar(64)   DEFAULT NULL,
    `biz_user_feature`     varchar(512)  DEFAULT NULL,
    `biz_user_id`          varchar(64)   DEFAULT NULL,
    `biz_user_key`         varchar(64)   DEFAULT NULL,
    `biz_user_name`        varchar(64)   DEFAULT NULL,
    `biz_user_org`         varchar(64)   DEFAULT NULL,
    `biz_user_tenant`      varchar(64)   DEFAULT NULL,
    `code`                 varchar(64) NOT NULL,
    `data_failed_count`    int           DEFAULT NULL,
    `data_processed_count` int           DEFAULT NULL,
    `data_success_count`   int           DEFAULT NULL,
    `data_total_count`     int           DEFAULT NULL,
    `env`                  varchar(64) NOT NULL,
    `execute_type`         varchar(64) NOT NULL,
    `feature`              text,
    `flow_order`           int           DEFAULT NULL,
    `flow_task_id`         varchar(64)   DEFAULT NULL,
    `gmt_create`           datetime(6) DEFAULT NULL,
    `gmt_dispatch`         datetime(6) DEFAULT NULL,
    `gmt_execute`          datetime(6) DEFAULT NULL,
    `gmt_expired`          datetime(6) DEFAULT NULL,
    `gmt_finished`         datetime(6) DEFAULT NULL,
    `gmt_modified`         datetime(6) DEFAULT NULL,
    `gmt_start`            datetime(6) DEFAULT NULL,
    `host`                 varchar(64)   DEFAULT NULL,
    `log`                  varchar(4096) DEFAULT NULL,
    `main_task_id`         varchar(64) NOT NULL,
    `name`                 varchar(64)   DEFAULT NULL,
    `namespace`            varchar(64) NOT NULL,
    `result_code`          varchar(64)   DEFAULT NULL,
    `result_message`       varchar(128)  DEFAULT NULL,
    `retry_times`          int           DEFAULT NULL,
    `row_status`           varchar(64)   DEFAULT NULL,
    `row_version`          int           DEFAULT NULL,
    `runtime_param`        text,
    `status`               varchar(64) NOT NULL,
    `sub_failed_count`     int           DEFAULT NULL,
    `sub_finished_count`   int           DEFAULT NULL,
    `sub_success_count`    int           DEFAULT NULL,
    `sub_total_count`      int           DEFAULT NULL,
    `tenant`               varchar(64) NOT NULL,
    `trace_id`             varchar(64)   DEFAULT NULL,
    `type`                 varchar(64) NOT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `uk_mainTaskId` (`main_task_id`),
    KEY                    `idx_main_task` (`tenant`,`namespace`,`app`,`env`,`code`),
    KEY                    `idx_bizUser` (`biz_user_tenant`,`biz_user_org`,`biz_user_id`,`biz_user_key`),
    KEY                    `idx_gmt_create` (`gmt_create`),
    KEY                    `idx_flowTaskId` (`flow_task_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;


CREATE TABLE `agei_sub_task_instance`
(
    `id`                   bigint      NOT NULL AUTO_INCREMENT,
    `app`                  varchar(64) NOT NULL,
    `biz_key`              varchar(64)   DEFAULT NULL,
    `biz_query`            text,
    `biz_task_name`        varchar(64)   DEFAULT NULL,
    `biz_user_feature`     varchar(512)  DEFAULT NULL,
    `biz_user_id`          varchar(64)   DEFAULT NULL,
    `biz_user_key`         varchar(64)   DEFAULT NULL,
    `biz_user_name`        varchar(64)   DEFAULT NULL,
    `biz_user_org`         varchar(64)   DEFAULT NULL,
    `biz_user_tenant`      varchar(64)   DEFAULT NULL,
    `code`                 varchar(64)   DEFAULT NULL,
    `data_failed_count`    int           DEFAULT NULL,
    `data_processed_count` int           DEFAULT NULL,
    `data_success_count`   int           DEFAULT NULL,
    `data_total_count`     int           DEFAULT NULL,
    `env`                  varchar(64) NOT NULL,
    `execute_type`         varchar(64) NOT NULL,
    `feature`              text,
    `flow_order`           int           DEFAULT NULL,
    `flow_task_id`         varchar(64)   DEFAULT NULL,
    `gmt_create`           datetime(6) DEFAULT NULL,
    `gmt_dispatch`         datetime(6) DEFAULT NULL,
    `gmt_execute`          datetime(6) DEFAULT NULL,
    `gmt_expired`          datetime(6) DEFAULT NULL,
    `gmt_finished`         datetime(6) DEFAULT NULL,
    `gmt_modified`         datetime(6) DEFAULT NULL,
    `gmt_start`            datetime(6) DEFAULT NULL,
    `host`                 varchar(64)   DEFAULT NULL,
    `log`                  varchar(4096) DEFAULT NULL,
    `main_task_id`         varchar(64)   DEFAULT NULL,
    `name`                 varchar(64)   DEFAULT NULL,
    `namespace`            varchar(64) NOT NULL,
    `result_code`          varchar(64)   DEFAULT NULL,
    `result_message`       varchar(128)  DEFAULT NULL,
    `retry_times`          int           DEFAULT NULL,
    `row_status`           varchar(64)   DEFAULT NULL,
    `row_version`          int           DEFAULT NULL,
    `runtime_param`        text,
    `status`               varchar(64) NOT NULL,
    `sub_task_id`          varchar(64)   DEFAULT NULL,
    `sub_task_no`          int           DEFAULT NULL,
    `tenant`               varchar(64) NOT NULL,
    `trace_id`             varchar(64)   DEFAULT NULL,
    `type`                 varchar(64) NOT NULL,
    PRIMARY KEY (`id`),
    KEY                    `idx_mainTaskId` (`main_task_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;


CREATE TABLE `agei_task_specification`
(
    `id`                bigint       NOT NULL AUTO_INCREMENT,
    `app`               varchar(64)  NOT NULL,
    `creator_id`        varchar(64) DEFAULT NULL,
    `creator_name`      varchar(64) DEFAULT NULL,
    `env`               varchar(64)  NOT NULL,
    `feature`           text,
    `gmt_create`        datetime(6) NOT NULL,
    `gmt_modified`      datetime(6) NOT NULL,
    `modifier_id`       varchar(64) DEFAULT NULL,
    `modifier_name`     varchar(64) DEFAULT NULL,
    `namespace`         varchar(64)  NOT NULL,
    `owner_id`          varchar(64) DEFAULT NULL,
    `owner_name`        varchar(64) DEFAULT NULL,
    `row_status`        varchar(64)  NOT NULL,
    `row_version`       int          NOT NULL,
    `status`            varchar(64)  NOT NULL,
    `task_code`         varchar(64)  NOT NULL,
    `task_desc`         varchar(128) NOT NULL,
    `task_execute_type` varchar(64)  NOT NULL,
    `task_handler`      varchar(512) NOT NULL,
    `task_name`         varchar(64)  NOT NULL,
    `task_type`         varchar(64)  NOT NULL,
    `tenant`            varchar(64)  NOT NULL,
    PRIMARY KEY (`id`),
    KEY                 `tenant_namespace_app_env_task_code` (`tenant`,`namespace`,`app`,`env`,`task_code`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;