/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.statemachine.impl;

import com.alibaba.cola.statemachine.State;
import com.alibaba.cola.statemachine.Transition;
import com.alibaba.cola.statemachine.Visitor;
import com.alibaba.cola.statemachine.impl.Debugger;
import com.alibaba.cola.statemachine.impl.EventTransitions;
import com.alibaba.cola.statemachine.impl.TransitionImpl;
import com.alibaba.cola.statemachine.impl.TransitionType;
import java.util.Collection;
import java.util.List;

public class StateImpl<S, E, C>
implements State<S, E, C> {
    protected final S stateId;
    private EventTransitions eventTransitions = new EventTransitions();

    StateImpl(S stateId) {
        this.stateId = stateId;
    }

    @Override
    public Transition<S, E, C> addTransition(E event, State<S, E, C> target, TransitionType transitionType) {
        TransitionImpl<S, E, C> newTransition = new TransitionImpl<S, E, C>();
        newTransition.setSource(this);
        newTransition.setTarget(target);
        newTransition.setEvent(event);
        newTransition.setType(transitionType);
        Debugger.debug("Begin to add new transition: " + newTransition);
        this.eventTransitions.put(event, newTransition);
        return newTransition;
    }

    @Override
    public List<Transition<S, E, C>> getEventTransitions(E event) {
        return this.eventTransitions.get(event);
    }

    @Override
    public Collection<Transition<S, E, C>> getAllTransitions() {
        return this.eventTransitions.allTransitions();
    }

    @Override
    public S getId() {
        return this.stateId;
    }

    @Override
    public String accept(Visitor visitor) {
        String entry = visitor.visitOnEntry(this);
        String exit = visitor.visitOnExit(this);
        return entry + exit;
    }

    public boolean equals(Object anObject) {
        State other;
        return anObject instanceof State && this.stateId.equals((other = (State)anObject).getId());
    }

    public String toString() {
        return this.stateId.toString();
    }
}

