/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.statemachine.impl;

import com.alibaba.cola.statemachine.Action;
import com.alibaba.cola.statemachine.Condition;
import com.alibaba.cola.statemachine.State;
import com.alibaba.cola.statemachine.Transition;
import com.alibaba.cola.statemachine.impl.Debugger;
import com.alibaba.cola.statemachine.impl.StateMachineException;
import com.alibaba.cola.statemachine.impl.TransitionType;

public class TransitionImpl<S, E, C>
implements Transition<S, E, C> {
    private State<S, E, C> source;
    private State<S, E, C> target;
    private E event;
    private Condition<C> condition;
    private Action<S, E, C> action;
    private TransitionType type = TransitionType.EXTERNAL;

    @Override
    public State<S, E, C> getSource() {
        return this.source;
    }

    @Override
    public void setSource(State<S, E, C> state) {
        this.source = state;
    }

    @Override
    public E getEvent() {
        return this.event;
    }

    @Override
    public void setEvent(E event) {
        this.event = event;
    }

    @Override
    public void setType(TransitionType type) {
        this.type = type;
    }

    @Override
    public State<S, E, C> getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(State<S, E, C> target) {
        this.target = target;
    }

    @Override
    public Condition<C> getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(Condition<C> condition) {
        this.condition = condition;
    }

    @Override
    public Action<S, E, C> getAction() {
        return this.action;
    }

    @Override
    public void setAction(Action<S, E, C> action) {
        this.action = action;
    }

    @Override
    public State<S, E, C> transit(C ctx, boolean checkCondition) {
        Debugger.debug("Do transition: " + this);
        this.verify();
        if (!checkCondition || this.condition == null || this.condition.isSatisfied(ctx)) {
            if (this.action != null) {
                this.action.execute(this.source.getId(), this.target.getId(), this.event, ctx);
            }
            return this.target;
        }
        Debugger.debug("Condition is not satisfied, stay at the " + this.source + " state ");
        return this.source;
    }

    public final String toString() {
        return this.source + "-[" + this.event.toString() + ", " + (Object)((Object)this.type) + "]->" + this.target;
    }

    public boolean equals(Object anObject) {
        Transition other;
        return anObject instanceof Transition && this.event.equals((other = (Transition)anObject).getEvent()) && this.source.equals(other.getSource()) && this.target.equals(other.getTarget());
    }

    @Override
    public void verify() {
        if (this.type == TransitionType.INTERNAL && this.source != this.target) {
            throw new StateMachineException(String.format("Internal transition source state '%s' and target state '%s' must be same.", this.source, this.target));
        }
    }
}

