/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.kubernetes.service.impl;

import cn.sliew.carp.module.kubernetes.service.K8sClusterService;
import cn.sliew.carp.module.kubernetes.service.KubernetesClientService;
import cn.sliew.carp.module.kubernetes.service.entity.Cluster;
import cn.sliew.carp.module.kubernetes.service.entity.spec.ClusterSpec;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KubernetesClientServiceImpl
implements KubernetesClientService {
    @Autowired
    private K8sClusterService k8sClusterService;

    @Override
    public KubernetesClient getClient(Long id) {
        return new KubernetesClientBuilder().withConfig(this.getConfig(id)).build();
    }

    @Override
    public NamespacedKubernetesClient getClient(Long id, String namespace) {
        Config config = this.getConfig(id);
        config.setNamespace(namespace);
        return (NamespacedKubernetesClient)new KubernetesClientBuilder().withConfig(config).build().adapt(NamespacedKubernetesClient.class);
    }

    @Override
    public Config getConfig(Long id) {
        Cluster cluster = this.k8sClusterService.get(id);
        ClusterSpec spec = (ClusterSpec)cluster.getSpec();
        Config config = null;
        switch (spec.getAuthMode()) {
            case "kubeconfig": {
                config = this.buildConfigFromContent(spec.getContext(), spec.getConfigContent());
                break;
            }
        }
        return config;
    }

    private Config buildConfigFromContent(String context, String configContent) {
        if (StringUtils.isNotBlank((CharSequence)configContent)) {
            return Config.fromKubeconfig((String)context, (String)configContent, null);
        }
        return Config.fromKubeconfig((String)configContent);
    }
}

