/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.spring.concurrent;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class MetricsThreadPoolExecutor
extends ThreadPoolTaskExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsThreadPoolExecutor.class);
    private final ThreadLocal<Long> startTimeThreadLocal = new ThreadLocal();
    private MeterRegistry meterRegistry;
    private List<Tag> tags;

    public void initialize() {
        super.initialize();
        this.enableMetrics(this.getThreadNamePrefix());
    }

    private void enableMetrics(String poolName) {
        this.tags = Collections.singletonList(Tag.of((String)"pool_name", (String)poolName));
        this.startWatch();
    }

    private void startWatch() {
        this.meterRegistry.gauge("job_thread_pool_active_thread_size", this.getTags(), (Object)this, threadPoolExecutor -> threadPoolExecutor.getActiveCount());
        this.meterRegistry.gauge("job_thread_pool_pool_size", this.getTags(), (Object)this, threadPoolExecutor -> threadPoolExecutor.getPoolSize());
        this.meterRegistry.gauge("job_thread_pool_core_pool_size", this.getTags(), (Object)this, threadPoolExecutor -> threadPoolExecutor.getCorePoolSize());
        this.meterRegistry.gauge("job_thread_pool_max_pool_size", this.getTags(), (Object)this, threadPoolExecutor -> threadPoolExecutor.getMaxPoolSize());
        this.meterRegistry.gauge("job_thread_pool_task_total", this.getTags(), (Object)this, threadPoolExecutor -> threadPoolExecutor.getThreadPoolExecutor().getTaskCount());
        this.meterRegistry.gauge("job_thread_pool_completed_task_total", this.getTags(), (Object)this, threadPoolExecutor -> threadPoolExecutor.getThreadPoolExecutor().getCompletedTaskCount());
        this.meterRegistry.gauge("job_thread_pool_queue_size", this.getTags(), (Object)this, threadPoolExecutor -> threadPoolExecutor.getQueueSize());
        this.meterRegistry.gauge("job_thread_pool_queue_capacity", this.getTags(), (Object)this, threadPoolExecutor -> threadPoolExecutor.getQueueCapacity());
    }

    private List<Tag> getTags() {
        return this.tags;
    }

    protected void beforeExecute(Thread t, Runnable r) {
        this.startTimeThreadLocal.set(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterExecute(Runnable r, Throwable t) {
        try {
            long costTime = System.currentTimeMillis() - this.startTimeThreadLocal.get();
            this.recordTaskCostTime(costTime);
        }
        finally {
            this.startTimeThreadLocal.remove();
        }
    }

    private void recordTaskCostTime(long costInMills) {
        try {
            Timer.builder((String)"job_thread_pool_tasks").tags(this.getTags()).publishPercentileHistogram(Boolean.valueOf(true)).register(this.meterRegistry).record(costInMills, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            log.warn("Fail to record thread pool task timer metrics", (Throwable)e);
        }
    }
}

