/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.rendering.DateHeaderRendering;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.headers.Connection;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusLength;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusType;
import org.apache.pekko.http.scaladsl.model.headers.CustomHeader;
import org.apache.pekko.http.scaladsl.model.headers.Date;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader;
import org.apache.pekko.http.scaladsl.model.headers.Server;
import org.apache.pekko.http.scaladsl.model.headers.Transfer$minusEncoding;
import org.apache.pekko.http.scaladsl.model.headers.User$minusAgent;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.VectorBuilder;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class HttpMessageRendering$ {
    public static HttpMessageRendering$ MODULE$;

    static {
        new HttpMessageRendering$();
    }

    public void addContentHeaders(VectorBuilder<Tuple2<String, String>> headerPairs, HttpEntity entity) {
        if (entity.contentType() != ContentTypes$.MODULE$.NoContentType()) {
            headerPairs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"content-type"), (Object)entity.contentType().toString()));
        }
        entity.contentLengthOption().foreach((Function1 & Serializable & scala.Serializable)x$2 -> headerPairs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"content-length"), (Object)Long.toString(BoxesRunTime.unboxToLong((Object)x$2)))));
    }

    public Seq<Tuple2<String, String>> renderHeaders(scala.collection.immutable.Seq<HttpHeader> headers2, LoggingAdapter log, boolean isServer, boolean shouldRenderAutoHeaders, DateHeaderRendering dateHeaderRendering) {
        VectorBuilder headerPairs = new VectorBuilder();
        this.renderHeaders(headers2, (VectorBuilder<Tuple2<String, String>>)headerPairs, (Option<Tuple2<String, String>>)None$.MODULE$, log, isServer, shouldRenderAutoHeaders, dateHeaderRendering);
        return headerPairs.result();
    }

    public void renderHeaders(scala.collection.immutable.Seq<HttpHeader> headersSeq, VectorBuilder<Tuple2<String, String>> headerPairs, Option<Tuple2<String, String>> peerIdHeader, LoggingAdapter log, boolean isServer, boolean shouldRenderAutoHeaders, DateHeaderRendering dateHeaderRendering) {
        Iterator it = headersSeq.iterator();
        boolean peerIdSeen = false;
        boolean dateSeen = false;
        while (it.hasNext()) {
            RawHeader rawHeader;
            HttpHeader header = (HttpHeader)it.next();
            if ((!header.renderInResponses() || !isServer) && (!header.renderInRequests() || isServer)) continue;
            if (header instanceof Server) {
                Server server = (Server)header;
                if (isServer) {
                    HttpMessageRendering$.addHeader$1(server, headerPairs);
                    peerIdSeen = true;
                    continue;
                }
            }
            if (header instanceof User$minusAgent) {
                User$minusAgent user$minusAgent = (User$minusAgent)header;
                if (!isServer) {
                    HttpMessageRendering$.addHeader$1(user$minusAgent, headerPairs);
                    peerIdSeen = true;
                    continue;
                }
            }
            if (header instanceof Date) {
                Date date = (Date)header;
                if (isServer) {
                    HttpMessageRendering$.addHeader$1(date, headerPairs);
                    dateSeen = true;
                    continue;
                }
            }
            if (header instanceof CustomHeader) {
                HttpMessageRendering$.addHeader$1((CustomHeader)header, headerPairs);
                continue;
            }
            if (header instanceof RawHeader && ((rawHeader = (RawHeader)header).is("content-type") || rawHeader.is("content-length") || rawHeader.is("transfer-encoding") || rawHeader.is("date") || rawHeader.is("server") || rawHeader.is("user-agent") || rawHeader.is("connection"))) {
                HttpMessageRendering$.suppressionWarning$1(rawHeader, "illegal RawHeader", log);
                continue;
            }
            if (header instanceof Content$minusLength) {
                HttpMessageRendering$.suppressionWarning$1((Content$minusLength)header, "explicit `Content-Length` header is not allowed. Use the appropriate HttpEntity subtype.", log);
                continue;
            }
            if (header instanceof Content$minusType) {
                HttpMessageRendering$.suppressionWarning$1((Content$minusType)header, "explicit `Content-Type` header is not allowed. Set `HttpResponse.entity.contentType` instead.", log);
                continue;
            }
            if (header instanceof Transfer$minusEncoding) {
                HttpMessageRendering$.suppressionWarning$1((Transfer$minusEncoding)header, "`Transfer-Encoding` header is not allowed for HTTP/2", log);
                continue;
            }
            if (header instanceof Connection) {
                HttpMessageRendering$.suppressionWarning$1((Connection)header, "`Connection` header is not allowed for HTTP/2", log);
                continue;
            }
            HttpMessageRendering$.addHeader$1(header, headerPairs);
        }
        if (shouldRenderAutoHeaders && !dateSeen && isServer) {
            headerPairs.$plus$eq(dateHeaderRendering.renderHeaderPair());
        }
        if (shouldRenderAutoHeaders && !peerIdSeen) {
            if (peerIdHeader instanceof Some) {
                Tuple2 peerIdTuple = (Tuple2)((Some)peerIdHeader).value();
                headerPairs.$plus$eq((Object)peerIdTuple);
                return;
            }
            if (None$.MODULE$.equals(peerIdHeader)) {
                return;
            }
            throw new MatchError(peerIdHeader);
        }
    }

    private static final void suppressionWarning$1(HttpHeader h, String msg, LoggingAdapter log$1) {
        log$1.warning("Explicitly set HTTP header '{}' is ignored, {}", (Object)h, (Object)msg);
    }

    private static final void addHeader$1(HttpHeader h, VectorBuilder headerPairs$2) {
        headerPairs$2.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)h.lowercaseName()), (Object)h.value()));
    }

    private HttpMessageRendering$() {
        MODULE$ = this;
    }
}

