/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.rendering;

import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.parsing.HttpResponseParser$OneHundredContinueError$;
import org.apache.pekko.http.impl.engine.rendering.HttpRequestRendererFactory;
import org.apache.pekko.http.impl.engine.rendering.RenderSupport$;
import org.apache.pekko.http.impl.engine.rendering.RenderSupport$CheckContentLengthTransformer$;
import org.apache.pekko.http.impl.engine.rendering.RenderSupport$ChunkTransformer$;
import org.apache.pekko.http.impl.engine.rendering.RequestRenderingContext;
import org.apache.pekko.http.impl.util.ByteStringRendering;
import org.apache.pekko.http.impl.util.Renderer$;
import org.apache.pekko.http.impl.util.package$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.RequestEntityAcceptance;
import org.apache.pekko.http.scaladsl.model.RequestEntityAcceptance$Expected$;
import org.apache.pekko.http.scaladsl.model.UriRendering$;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusLength;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusLength$;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusType;
import org.apache.pekko.http.scaladsl.model.headers.CustomHeader;
import org.apache.pekko.http.scaladsl.model.headers.Host;
import org.apache.pekko.http.scaladsl.model.headers.Raw$minusRequest$minusURI;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader;
import org.apache.pekko.http.scaladsl.model.headers.Transfer$minusEncoding;
import org.apache.pekko.http.scaladsl.model.headers.Transfer$minusEncoding$;
import org.apache.pekko.http.scaladsl.model.headers.User$minusAgent;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t-c!\u0002\u001f>\u0001\r[\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011\u0002+\t\u0011\u0005\u0004!\u0011!Q\u0001\n\tD\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\u0006Y\u0002!\t!\u001c\u0005\u0006g\u0002!\t\u0001\u001e\u0005\b\u0003+\u0001A\u0011AA\f\u0011\u001d\t)\u0003\u0001C\u0001\u0005w9\u0001\"!\b>\u0011\u0003\u0019\u0015q\u0004\u0004\byuB\taQA\u0011\u0011\u0019a\u0017\u0002\"\u0001\u0002$!9\u0011QE\u0005\u0005\u0002\u0005\u001db!CA\u001e\u0013A\u0005\u0019\u0013EA\u001f\u0011\u001d\ty\u0004\u0004D\u0001\u0003\u0003:qAa\u000e\n\u0011\u0003\tYEB\u0004\u0002<%A\t!a\u0012\t\r1|A\u0011AA%\r\u0019\tye\u0004!\u0002R!Q\u0011\u0011M\t\u0003\u0016\u0004%\t!a\u0019\t\u0013\u0005\u0015\u0014C!E!\u0002\u0013a\bB\u00027\u0012\t\u0003\t9\u0007C\u0004\u0002@E!\t!!\u0011\t\u0013\u0005=\u0014#!A\u0005\u0002\u0005E\u0004\"CA;#E\u0005I\u0011AA<\u0011%\ti)EA\u0001\n\u0003\ny\tC\u0005\u0002\"F\t\t\u0011\"\u0001\u0002$\"I\u0011QU\t\u0002\u0002\u0013\u0005\u0011q\u0015\u0005\n\u0003[\u000b\u0012\u0011!C!\u0003_C\u0011\"!0\u0012\u0003\u0003%\t!a0\t\u0013\u0005%\u0017#!A\u0005B\u0005-\u0007\"CAg#\u0005\u0005I\u0011IAh\u0011%\t\t.EA\u0001\n\u0003\n\u0019nB\u0005\u0002X>\t\t\u0011#\u0001\u0002Z\u001aI\u0011qJ\b\u0002\u0002#\u0005\u00111\u001c\u0005\u0007Y\u0006\"\t!!;\t\u0013\u00055\u0017%!A\u0005F\u0005=\u0007\"CAvC\u0005\u0005I\u0011QAw\u0011%\t\t0IA\u0001\n\u0003\u000b\u0019\u0010C\u0005\u0002|\u0006\n\t\u0011\"\u0003\u0002~\u001a1\u0011QI\bA\u00057A!\"a\u0010(\u0005+\u0007I\u0011AA!\u0011%\u0011ib\nB\tB\u0003%Q\u000f\u0003\u0004mO\u0011\u0005!q\u0004\u0005\n\u0003_:\u0013\u0011!C\u0001\u0005GA\u0011\"!\u001e(#\u0003%\tAa\n\t\u0013\u00055u%!A\u0005B\u0005=\u0005\"CAQO\u0005\u0005I\u0011AAR\u0011%\t)kJA\u0001\n\u0003\u0011Y\u0003C\u0005\u0002.\u001e\n\t\u0011\"\u0011\u00020\"I\u0011QX\u0014\u0002\u0002\u0013\u0005!q\u0006\u0005\n\u0003\u0013<\u0013\u0011!C!\u0003\u0017D\u0011\"!4(\u0003\u0003%\t%a4\t\u0013\u0005Ew%!A\u0005B\tMr!\u0003B\u0003\u001f\u0005\u0005\t\u0012\u0001B\u0004\r%\t)eDA\u0001\u0012\u0003\u0011I\u0001\u0003\u0004mm\u0011\u0005!q\u0002\u0005\n\u0003\u001b4\u0014\u0011!C#\u0003\u001fD\u0011\"a;7\u0003\u0003%\tI!\u0005\t\u0013\u0005Eh'!A\u0005\u0002\nU\u0001\"CA~m\u0005\u0005I\u0011BA\u007f\u0005iAE\u000f\u001e9SKF,Xm\u001d;SK:$WM]3s\r\u0006\u001cGo\u001c:z\u0015\tqt(A\u0005sK:$WM]5oO*\u0011\u0001)Q\u0001\u0007K:<\u0017N\\3\u000b\u0005\t\u001b\u0015\u0001B5na2T!\u0001R#\u0002\t!$H\u000f\u001d\u0006\u0003\r\u001e\u000bQ\u0001]3lW>T!\u0001S%\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0015aA8sON\u0011\u0001\u0001\u0014\t\u0003\u001bBk\u0011A\u0014\u0006\u0002\u001f\u0006)1oY1mC&\u0011\u0011K\u0014\u0002\u0007\u0003:L(+\u001a4\u0002\u001fU\u001cXM]!hK:$\b*Z1eKJ\u001c\u0001\u0001E\u0002N+^K!A\u0016(\u0003\r=\u0003H/[8o!\tAv,D\u0001Z\u0015\tQ6,A\u0004iK\u0006$WM]:\u000b\u0005qk\u0016!B7pI\u0016d'B\u00010D\u0003!\u00198-\u00197bINd\u0017B\u00011Z\u0005=)6/\u001a:%[&tWo]!hK:$\u0018!\u0006:fcV,7\u000f\u001e%fC\u0012,'oU5{K\"Kg\u000e\u001e\t\u0003\u001b\u000eL!\u0001\u001a(\u0003\u0007%sG/A\u0002m_\u001e\u0004\"a\u001a6\u000e\u0003!T!![#\u0002\u000b\u00154XM\u001c;\n\u0005-D'A\u0004'pO\u001eLgnZ!eCB$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\t9\u0004\u0018O\u001d\t\u0003_\u0002i\u0011!\u0010\u0005\u0006%\u0012\u0001\r\u0001\u0016\u0005\u0006C\u0012\u0001\rA\u0019\u0005\u0006K\u0012\u0001\rAZ\u0001\u000fe\u0016tG-\u001a:U_N{WO]2f)\r)\u00181\u0002\t\u0006mjd\u0018QA\u0007\u0002o*\u0011a\f\u001f\u0006\u0003s\u0016\u000baa\u001d;sK\u0006l\u0017BA>x\u0005\u0019\u0019v.\u001e:dKB\u0019Q0!\u0001\u000e\u0003yT!a`#\u0002\tU$\u0018\u000e\\\u0005\u0004\u0003\u0007q(A\u0003\"zi\u0016\u001cFO]5oOB\u0019Q*a\u0002\n\u0007\u0005%aJA\u0002B]fDq!!\u0004\u0006\u0001\u0004\ty!A\u0002dib\u00042a\\A\t\u0013\r\t\u0019\"\u0010\u0002\u0018%\u0016\fX/Z:u%\u0016tG-\u001a:j]\u001e\u001cuN\u001c;fqR\faA]3oI\u0016\u0014H\u0003BA\r\u0005s\u00012!a\u0007\r\u001d\ty\u0007\"\u0001\u000eIiR\u0004(+Z9vKN$(+\u001a8eKJ,'OR1di>\u0014\u0018\u0010\u0005\u0002p\u0013M\u0011\u0011\u0002\u0014\u000b\u0003\u0003?\tAB]3oI\u0016\u00148\u000b\u001e:jGR$r\u0001`A\u0015\u0003W\tI\u0004C\u0004\u0002\u000e-\u0001\r!a\u0004\t\u000f\u000552\u00021\u0001\u00020\u0005A1/\u001a;uS:<7\u000f\u0005\u0003\u00022\u0005URBAA\u001a\u0015\r\ti#X\u0005\u0005\u0003o\t\u0019D\u0001\rDY&,g\u000e^\"p]:,7\r^5p]N+G\u000f^5oONDQ!Z\u0006A\u0002\u0019\u0014aCU3rk\u0016\u001cHOU3oI\u0016\u0014\u0018N\\4PkR\u0004X\u000f^\n\u0003\u00191\u000b!BY=uKN#(/Z1n+\u0005)\u0018f\u0001\u0007(#\tA1\u000b\u001e:fC6,Gm\u0005\u0002\u0010\u0019R\u0011\u00111\n\t\u0004\u0003\u001bzQ\"A\u0005\u0003\rM#(/[2u'!\tB*a\u0015\u0002V\u0005m\u0003cAA'\u0019A\u0019Q*a\u0016\n\u0007\u0005ecJA\u0004Qe>$Wo\u0019;\u0011\u00075\u000bi&C\u0002\u0002`9\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fQAY=uKN,\u0012\u0001`\u0001\u0007Ef$Xm\u001d\u0011\u0015\t\u0005%\u0014Q\u000e\t\u0004\u0003W\nR\"A\b\t\r\u0005\u0005D\u00031\u0001}\u0003\u0011\u0019w\u000e]=\u0015\t\u0005%\u00141\u000f\u0005\t\u0003C2\u0002\u0013!a\u0001y\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA=U\ra\u00181P\u0016\u0003\u0003{\u0002B!a \u0002\n6\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000b))A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0011(\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\f\u0006\u0005%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!%\u0011\t\u0005M\u0015QT\u0007\u0003\u0003+SA!a&\u0002\u001a\u0006!A.\u00198h\u0015\t\tY*\u0001\u0003kCZ\f\u0017\u0002BAP\u0003+\u0013aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLX#\u00012\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QAAU\u0011!\tYKGA\u0001\u0002\u0004\u0011\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00022B1\u00111WA]\u0003\u000bi!!!.\u000b\u0007\u0005]f*\u0001\u0006d_2dWm\u0019;j_:LA!a/\u00026\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\t-a2\u0011\u00075\u000b\u0019-C\u0002\u0002F:\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002,r\t\t\u00111\u0001\u0002\u0006\u0005A\u0001.Y:i\u0007>$W\rF\u0001c\u0003!!xn\u0015;sS:<GCAAI\u0003\u0019)\u0017/^1mgR!\u0011\u0011YAk\u0011%\tYkHA\u0001\u0002\u0004\t)!\u0001\u0004TiJL7\r\u001e\t\u0004\u0003W\n3#B\u0011\u0002^\u0006m\u0003cBAp\u0003Kd\u0018\u0011N\u0007\u0003\u0003CT1!a9O\u0003\u001d\u0011XO\u001c;j[\u0016LA!a:\u0002b\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0015\u0005\u0005e\u0017!B1qa2LH\u0003BA5\u0003_Da!!\u0019%\u0001\u0004a\u0018aB;oCB\u0004H.\u001f\u000b\u0005\u0003k\f9\u0010E\u0002N+rD\u0011\"!?&\u0003\u0003\u0005\r!!\u001b\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAA\u0000!\u0011\t\u0019J!\u0001\n\t\t\r\u0011Q\u0013\u0002\u0007\u001f\nTWm\u0019;\u0002\u0011M#(/Z1nK\u0012\u00042!a\u001b7'\u00151$1BA.!\u001d\ty.!:v\u0005\u001b\u00012!a\u001b()\t\u00119\u0001\u0006\u0003\u0003\u000e\tM\u0001BBA s\u0001\u0007Q\u000f\u0006\u0003\u0003\u0018\te\u0001cA'Vk\"I\u0011\u0011 \u001e\u0002\u0002\u0003\u0007!QB\n\tO1\u000b\u0019&!\u0016\u0002\\\u0005Y!-\u001f;f'R\u0014X-Y7!)\u0011\u0011iA!\t\t\r\u0005}\"\u00061\u0001v)\u0011\u0011iA!\n\t\u0011\u0005}2\u0006%AA\u0002U,\"A!\u000b+\u0007U\fY\b\u0006\u0003\u0002\u0006\t5\u0002\u0002CAV_\u0005\u0005\t\u0019\u00012\u0015\t\u0005\u0005'\u0011\u0007\u0005\n\u0003W\u000b\u0014\u0011!a\u0001\u0003\u000b!B!!1\u00036!I\u00111\u0016\u001b\u0002\u0002\u0003\u0007\u0011QA\u0001\u0017%\u0016\fX/Z:u%\u0016tG-\u001a:j]\u001e|U\u000f\u001e9vi\"9\u0011Q\u0002\u0004A\u0002\u0005=Ac\u0001?\u0003>!9\u0011QB\u0004A\u0002\u0005=\u0001f\u0001\u0001\u0003BA!!1\tB$\u001b\t\u0011)EC\u0002\u0002\b\u0016KAA!\u0013\u0003F\tY\u0011J\u001c;fe:\fG.\u00119j\u0001")
@InternalApi
public class HttpRequestRendererFactory {
    private final Option<User$minusAgent> userAgentHeader;
    private final int requestHeaderSizeHint;
    private final LoggingAdapter log;

    public Source<ByteString, Object> renderToSource(RequestRenderingContext ctx) {
        return this.render(ctx).byteStream();
    }

    public RequestRenderingOutput render(RequestRenderingContext ctx) {
        ByteStringRendering r = new ByteStringRendering(this.requestHeaderSizeHint, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)message -> {
            this.log.warning(message);
            return BoxedUnit.UNIT;
        });
        HttpRequestRendererFactory.renderRequestLine$1(r, ctx);
        this.renderHeaders$1(ctx.request().headers().toList(), HttpRequestRendererFactory.renderHeaders$default$2$1(), HttpRequestRendererFactory.renderHeaders$default$3$1(), HttpRequestRendererFactory.renderHeaders$default$4$1(), ctx, r);
        RenderSupport$.MODULE$.renderEntityContentType(r, ctx.request().entity());
        return HttpRequestRendererFactory.completeRequestRendering$1(ctx, r);
    }

    public ByteString renderStrict(RequestRenderingContext ctx) {
        RequestRenderingOutput requestRenderingOutput = this.render(ctx);
        if (requestRenderingOutput instanceof RequestRenderingOutput.Strict) {
            return ((RequestRenderingOutput.Strict)requestRenderingOutput).bytes();
        }
        if (requestRenderingOutput instanceof RequestRenderingOutput.Streamed) {
            throw new IllegalArgumentException(new StringBuilder(34).append("Request entity was not Strict but ").append(ctx.request().entity().getClass().getSimpleName()).toString());
        }
        throw new MatchError((Object)requestRenderingOutput);
    }

    public static final /* synthetic */ boolean $anonfun$render$2(ByteStringRendering r$1, HttpHeader x0$1) {
        if (x0$1 instanceof Raw$minusRequest$minusURI) {
            String rawUri = ((Raw$minusRequest$minusURI)x0$1).uri();
            r$1.$tilde$tilde(rawUri);
            return true;
        }
        return false;
    }

    private static final void renderRequestLine$1(ByteStringRendering r$1, RequestRenderingContext ctx$1) {
        ((ByteStringRendering)r$1.$tilde$tilde(ctx$1.request().method(), Renderer$.MODULE$.renderableRenderer())).$tilde$tilde(' ');
        if (!ctx$1.request().headers().exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)HttpRequestRendererFactory.$anonfun$render$2(r$1, x0$1)))) {
            UriRendering$.MODULE$.renderUriWithoutFragment(r$1, ctx$1.request().uri(), package$.MODULE$.UTF8());
        }
        ((ByteStringRendering)r$1.$tilde$tilde(' ').$tilde$tilde(ctx$1.request().protocol(), Renderer$.MODULE$.renderableRenderer())).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
    }

    private static final ByteStringRendering render$1(HttpHeader h, ByteStringRendering r$1) {
        return (ByteStringRendering)r$1.$tilde$tilde(h);
    }

    private final void renderHeaders$1(List remaining, boolean hostHeaderSeen, boolean userAgentSeen, boolean transferEncodingSeen, RequestRenderingContext ctx$1, ByteStringRendering r$1) {
        while (remaining instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)remaining;
            HttpHeader head = (HttpHeader)colon2.head();
            List tail = colon2.tl$access$1();
            boolean bl = false;
            RawHeader rawHeader = null;
            if (head instanceof Content$minusLength) {
                Content$minusLength content$minusLength = (Content$minusLength)head;
                RenderSupport$.MODULE$.suppressionWarning(this.log, content$minusLength, "explicit `Content-Length` header is not allowed. Use the appropriate HttpEntity subtype.");
                remaining = tail;
                continue;
            }
            if (head instanceof Content$minusType) {
                Content$minusType content$minusType = (Content$minusType)head;
                RenderSupport$.MODULE$.suppressionWarning(this.log, content$minusType, "explicit `Content-Type` header is not allowed. Set `HttpRequest.entity.contentType` instead.");
                remaining = tail;
                continue;
            }
            if (head instanceof Transfer$minusEncoding) {
                Option<Transfer$minusEncoding> option = ((Transfer$minusEncoding)head).withChunkedPeeled();
                if (None$.MODULE$.equals(option)) {
                    RenderSupport$.MODULE$.suppressionWarning(this.log, head, RenderSupport$.MODULE$.suppressionWarning$default$3());
                    remaining = tail;
                    continue;
                }
                if (option instanceof Some) {
                    Transfer$minusEncoding te = (Transfer$minusEncoding)((Some)option).value();
                    HttpRequestRendererFactory.render$1(ctx$1.request().entity().isChunked() && !ctx$1.request().entity().isKnownEmpty() ? te.withChunked() : te, r$1);
                    transferEncodingSeen = true;
                    remaining = tail;
                    continue;
                }
                throw new MatchError(option);
            }
            if (head instanceof Host) {
                HttpRequestRendererFactory.render$1((Host)head, r$1);
                hostHeaderSeen = true;
                remaining = tail;
                continue;
            }
            if (head instanceof User$minusAgent) {
                HttpRequestRendererFactory.render$1((User$minusAgent)head, r$1);
                userAgentSeen = true;
                remaining = tail;
                continue;
            }
            if (head instanceof Raw$minusRequest$minusURI) {
                remaining = tail;
                continue;
            }
            if (head instanceof CustomHeader) {
                CustomHeader customHeader = (CustomHeader)head;
                if (customHeader.renderInRequests()) {
                    HttpRequestRendererFactory.render$1(customHeader, r$1);
                }
                remaining = tail;
                continue;
            }
            if (head instanceof RawHeader) {
                bl = true;
                rawHeader = (RawHeader)head;
                if (rawHeader.is("content-type") || rawHeader.is("content-length") || rawHeader.is("transfer-encoding")) {
                    RenderSupport$.MODULE$.suppressionWarning(this.log, rawHeader, "illegal RawHeader");
                    remaining = tail;
                    continue;
                }
            }
            if (bl && rawHeader.is("user-agent")) {
                HttpRequestRendererFactory.render$1(rawHeader, r$1);
                userAgentSeen = true;
                remaining = tail;
                continue;
            }
            if (bl && rawHeader.is("host")) {
                HttpRequestRendererFactory.render$1(rawHeader, r$1);
                hostHeaderSeen = true;
                remaining = tail;
                continue;
            }
            if (head.renderInRequests()) {
                HttpRequestRendererFactory.render$1(head, r$1);
            } else {
                this.log.warning("HTTP header '{}' is not allowed in requests", (Object)head);
            }
            remaining = tail;
        }
        if (Nil$.MODULE$.equals(remaining)) {
            if (!hostHeaderSeen) {
                r$1.$tilde$tilde(ctx$1.hostHeader());
            }
            if (!userAgentSeen && this.userAgentHeader.isDefined()) {
                r$1.$tilde$tilde((HttpHeader)this.userAgentHeader.get());
            }
            if (ctx$1.request().entity().isChunked() && !ctx$1.request().entity().isKnownEmpty() && !transferEncodingSeen) {
                ((ByteStringRendering)r$1.$tilde$tilde(Transfer$minusEncoding$.MODULE$, Renderer$.MODULE$.renderableRenderer())).$tilde$tilde(RenderSupport$.MODULE$.ChunkedBytes()).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
                return;
            }
        } else {
            throw new MatchError((Object)remaining);
        }
    }

    private static final boolean renderHeaders$default$2$1() {
        return false;
    }

    private static final boolean renderHeaders$default$3$1() {
        return false;
    }

    private static final boolean renderHeaders$default$4$1() {
        return false;
    }

    private static final ByteStringRendering renderContentLength$1(long contentLength, RequestRenderingContext ctx$1, ByteStringRendering r$1) {
        block2: {
            block3: {
                if (!ctx$1.request().method().isEntityAccepted()) break block2;
                if (contentLength > 0L) break block3;
                RequestEntityAcceptance requestEntityAcceptance = ctx$1.request().method().requestEntityAcceptance();
                RequestEntityAcceptance$Expected$ requestEntityAcceptance$Expected$ = RequestEntityAcceptance$Expected$.MODULE$;
                if (requestEntityAcceptance != null ? !requestEntityAcceptance.equals(requestEntityAcceptance$Expected$) : requestEntityAcceptance$Expected$ != null) break block2;
            }
            return ((ByteStringRendering)r$1.$tilde$tilde(Content$minusLength$.MODULE$, Renderer$.MODULE$.renderableRenderer()).$tilde$tilde(contentLength)).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
        }
        return r$1;
    }

    private static final RequestRenderingOutput renderStreamed$1(Source body, ByteStringRendering r$1, RequestRenderingContext ctx$1) {
        Source source;
        Source headerPart = Source$.MODULE$.single((Object)r$1.get());
        Option<Future<NotUsed>> option = ctx$1.sendEntityTrigger();
        if (None$.MODULE$.equals(option)) {
            source = (Source)headerPart.$plus$plus((Graph)body);
        } else if (option instanceof Some) {
            Future future = (Future)((Some)option).value();
            Source barrier = (Source)Source$.MODULE$.fromFuture(future).drop(1L);
            source = (Source)headerPart.$plus$plus((Graph)barrier).$plus$plus((Graph)body).recoverWithRetries(-1, (PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    if (HttpResponseParser$OneHundredContinueError$.MODULE$.equals(x1)) {
                        return (B1)Source$.MODULE$.empty();
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    return HttpResponseParser$OneHundredContinueError$.MODULE$.equals(x1);
                }
            });
        } else {
            throw new MatchError(option);
        }
        Source stream = source;
        return new RequestRenderingOutput.Streamed((Source<ByteString, Object>)stream);
    }

    private static final RequestRenderingOutput completeRequestRendering$1(RequestRenderingContext ctx$1, ByteStringRendering r$1) {
        RequestEntity requestEntity = ctx$1.request().entity();
        if (requestEntity.isKnownEmpty()) {
            HttpRequestRendererFactory.renderContentLength$1(0L, ctx$1, r$1).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
            return new RequestRenderingOutput.Strict(r$1.get());
        }
        if (requestEntity instanceof HttpEntity.Strict) {
            ByteString data = ((HttpEntity.Strict)requestEntity).data();
            HttpRequestRendererFactory.renderContentLength$1(data.length(), ctx$1, r$1).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
            if (ctx$1.sendEntityTrigger().isDefined()) {
                return HttpRequestRendererFactory.renderStreamed$1(Source$.MODULE$.single((Object)data), r$1, ctx$1);
            }
            return new RequestRenderingOutput.Strict(r$1.get().$plus$plus(data));
        }
        if (requestEntity instanceof HttpEntity.Default) {
            HttpEntity.Default default_ = (HttpEntity.Default)requestEntity;
            long contentLength = default_.contentLength();
            Source<ByteString, Object> data = default_.data();
            HttpRequestRendererFactory.renderContentLength$1(contentLength, ctx$1, r$1).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
            return HttpRequestRendererFactory.renderStreamed$1(data.via(RenderSupport$CheckContentLengthTransformer$.MODULE$.flow(contentLength)), r$1, ctx$1);
        }
        if (requestEntity instanceof HttpEntity.Chunked) {
            Source<HttpEntity.ChunkStreamPart, Object> chunks = ((HttpEntity.Chunked)requestEntity).chunks();
            r$1.$tilde$tilde(RenderSupport$.MODULE$.CrLf());
            return HttpRequestRendererFactory.renderStreamed$1(chunks.via(RenderSupport$ChunkTransformer$.MODULE$.flow()), r$1, ctx$1);
        }
        throw new MatchError((Object)requestEntity);
    }

    public HttpRequestRendererFactory(Option<User$minusAgent> userAgentHeader, int requestHeaderSizeHint, LoggingAdapter log) {
        this.userAgentHeader = userAgentHeader;
        this.requestHeaderSizeHint = requestHeaderSizeHint;
        this.log = log;
    }

    public static interface RequestRenderingOutput {
        public Source<ByteString, Object> byteStream();
    }
}

