/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.model;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.util.StreamUtils$;
import org.apache.pekko.http.impl.util.StreamUtils$CaptureTerminationOp$;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Chunked$;
import org.apache.pekko.http.scaladsl.model.UniversalEntity;
import org.apache.pekko.stream.scaladsl.FileIO$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Tuple2;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;

public final class HttpEntity$ {
    public static HttpEntity$ MODULE$;
    private final HttpEntity.Strict Empty;

    static {
        new HttpEntity$();
    }

    public HttpEntity.Strict apply(String string) {
        return this.apply(ContentTypes$.MODULE$.text$divplain$u0028UTF$minus8$u0029(), string);
    }

    public HttpEntity.Strict apply(byte[] bytes) {
        return this.apply((ContentType)ContentTypes$.MODULE$.application$divoctet$minusstream(), bytes);
    }

    public HttpEntity.Strict apply(ByteString data) {
        return this.apply((ContentType)ContentTypes$.MODULE$.application$divoctet$minusstream(), data);
    }

    public HttpEntity.Strict apply(ContentType.NonBinary contentType, String string) {
        if (string.isEmpty()) {
            return this.empty(contentType);
        }
        return this.apply((ContentType)contentType, ByteString$.MODULE$.fromArrayUnsafe(string.getBytes(contentType.charset().nioCharset())));
    }

    public HttpEntity.Strict apply(ContentType.WithFixedCharset contentType, String string) {
        if (string.isEmpty()) {
            return this.empty(contentType);
        }
        return this.apply((ContentType)contentType, ByteString$.MODULE$.fromArrayUnsafe(string.getBytes(contentType.charset().nioCharset())));
    }

    public HttpEntity.Strict apply(ContentType contentType, byte[] bytes) {
        if (bytes.length == 0) {
            return this.empty(contentType);
        }
        return this.apply(contentType, ByteString$.MODULE$.apply(bytes));
    }

    public HttpEntity.Strict apply(ContentType contentType, ByteString data) {
        if (data.isEmpty()) {
            return this.empty(contentType);
        }
        return new HttpEntity.Strict(contentType, data);
    }

    public UniversalEntity apply(ContentType contentType, long contentLength, Source<ByteString, Object> data) {
        if (contentLength == 0L) {
            return this.empty(contentType);
        }
        return new HttpEntity.Default(contentType, contentLength, data);
    }

    public HttpEntity.Chunked apply(ContentType contentType, Source<ByteString, Object> data) {
        return HttpEntity$Chunked$.MODULE$.fromData(contentType, data);
    }

    public UniversalEntity fromFile(ContentType contentType, File file, int chunkSize) {
        return this.fromPath(contentType, file.toPath(), chunkSize);
    }

    public int fromFile$default$3() {
        return -1;
    }

    public UniversalEntity fromPath(ContentType contentType, Path file, int chunkSize) {
        long fileLength = Files.size(file);
        if (fileLength > 0L) {
            return new HttpEntity.Default(contentType, fileLength, (Source<ByteString, Object>)(chunkSize > 0 ? FileIO$.MODULE$.fromPath(file, chunkSize) : FileIO$.MODULE$.fromPath(file, FileIO$.MODULE$.fromPath$default$2())));
        }
        return this.empty(contentType);
    }

    public int fromPath$default$3() {
        return -1;
    }

    public HttpEntity.Strict Empty() {
        return this.Empty;
    }

    public HttpEntity.Strict empty(ContentType contentType) {
        ContentType contentType2 = contentType;
        ContentType contentType3 = this.Empty().contentType();
        if (!(contentType2 != null ? !contentType2.equals(contentType3) : contentType3 != null)) {
            return this.Empty();
        }
        return new HttpEntity.Strict(contentType, ByteString$.MODULE$.empty());
    }

    public <Mat> Source<ByteString, Mat> limitableByteSource(Source<ByteString, Mat> source) {
        return source;
    }

    public <Mat> Source<HttpEntity.ChunkStreamPart, Mat> limitableChunkSource(Source<HttpEntity.ChunkStreamPart, Mat> source) {
        return source;
    }

    @InternalApi
    public <T extends HttpEntity> Tuple2<T, Future<BoxedUnit>> captureTermination(T entity) {
        if (entity.isStrict()) {
            return new Tuple2(entity, StreamUtils$CaptureTerminationOp$.MODULE$.strictM());
        }
        return StreamUtils$.MODULE$.transformEntityStream(entity, StreamUtils$CaptureTerminationOp$.MODULE$);
    }

    public HttpEntity HttpEntityScalaDSLSugar(HttpEntity httpEntity) {
        return httpEntity;
    }

    private HttpEntity$() {
        MODULE$ = this;
        this.Empty = new HttpEntity.Strict(ContentTypes$.MODULE$.NoContentType(), ByteString$.MODULE$.empty());
    }
}

