/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.scheduler.api.configuration;

import cn.sliew.carp.module.scheduler.api.annotation.CarpJob;
import cn.sliew.carp.module.scheduler.api.executor.DefaultJobExecutor;
import cn.sliew.carp.module.scheduler.api.executor.DefaultJobThreadRepository;
import cn.sliew.carp.module.scheduler.api.executor.JobExecutor;
import cn.sliew.carp.module.scheduler.api.executor.JobHandlerFactoryRegistry;
import cn.sliew.carp.module.scheduler.api.executor.handler.bean.BeanJobHandlerFactory;
import cn.sliew.carp.module.scheduler.api.executor.handler.method.MethodJobhandlerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={CarpJob.class})
public class CarpJobAutoConfiguration {
    @Bean
    public JobHandlerFactoryRegistry jobHandlerFactoryRegistry(MethodJobhandlerFactory methodJobhandlerFactory, BeanJobHandlerFactory beanJobHandlerFactory) {
        JobHandlerFactoryRegistry registry = new JobHandlerFactoryRegistry();
        registry.replace(methodJobhandlerFactory.getType(), methodJobhandlerFactory);
        registry.replace(beanJobHandlerFactory.getType(), beanJobHandlerFactory);
        return registry;
    }

    @Bean
    public MethodJobhandlerFactory methodJobhandlerFactory() {
        return new MethodJobhandlerFactory();
    }

    @Bean
    public BeanJobHandlerFactory beanJobHandlerFactory() {
        return new BeanJobHandlerFactory();
    }

    @Bean
    @ConditionalOnMissingBean(value={JobExecutor.class})
    public JobExecutor defaultJobExecutor(JobHandlerFactoryRegistry jobHandlerFactoryRegistry) {
        return new DefaultJobExecutor(jobHandlerFactoryRegistry, new DefaultJobThreadRepository());
    }
}

