/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.scheduler.api.executor.handler.method;

import cn.hutool.extra.spring.SpringUtil;
import cn.sliew.carp.module.scheduler.api.annotation.CarpJob;
import cn.sliew.carp.module.scheduler.api.annotation.CarpJobHandler;
import cn.sliew.carp.module.scheduler.api.executor.AbstractJobHandlerFactory;
import cn.sliew.carp.module.scheduler.api.executor.JobContext;
import cn.sliew.carp.module.scheduler.api.executor.JobHandler;
import cn.sliew.carp.module.scheduler.api.executor.JobHandlerFactory;
import cn.sliew.carp.module.scheduler.api.executor.handler.method.MethodJobHandler;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public class MethodJobhandlerFactory
extends AbstractJobHandlerFactory
implements JobHandlerFactory,
SmartInitializingSingleton {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MethodJobhandlerFactory.class);
    private ConcurrentMap<String, CarpJobMethod> registry = new ConcurrentHashMap<String, CarpJobMethod>();

    @Override
    public String getType() {
        return "method";
    }

    @Override
    protected JobHandler create(String jobHandler) {
        Method destroyMethod;
        if (!this.registry.containsKey(jobHandler)) {
            throw new IllegalStateException("Unknown job handler: " + jobHandler);
        }
        CarpJobMethod carpJobMethod = (CarpJobMethod)this.registry.get(jobHandler);
        Object bean = carpJobMethod.getBean();
        Method method = carpJobMethod.getMethod();
        CarpJobHandler carpJobHandler = carpJobMethod.getCarpJobHandler();
        Method initMethod = ReflectionUtils.findMethod(bean.getClass(), (String)carpJobHandler.initMethod(), (Class[])new Class[]{JobContext.class});
        if (Objects.nonNull(initMethod)) {
            ReflectionUtils.makeAccessible((Method)initMethod);
        }
        if (Objects.nonNull(destroyMethod = ReflectionUtils.findMethod(bean.getClass(), (String)carpJobHandler.destroyMethod(), (Class[])new Class[]{JobContext.class}))) {
            ReflectionUtils.makeAccessible((Method)destroyMethod);
        }
        return new MethodJobHandler(bean, method, initMethod, destroyMethod);
    }

    public void afterSingletonsInstantiated() {
        this.scanBean();
    }

    private void scanBean() {
        String[] beanNames;
        ApplicationContext applicationContext = SpringUtil.getApplicationContext();
        for (String beanName : beanNames = applicationContext.getBeanNamesForAnnotation(CarpJob.class)) {
            Object bean = null;
            Lazy onBean = (Lazy)applicationContext.findAnnotationOnBean(beanName, Lazy.class);
            if (onBean != null) {
                log.debug("@CarpJobHandler annotation scan, skip @Lazy bean: {}", (Object)beanName);
            } else {
                bean = applicationContext.getBean(beanName);
            }
            if (!Objects.nonNull(bean)) continue;
            this.findCarpJob(bean, beanName);
        }
    }

    private void findCarpJob(Object bean, String beanName) {
        Map annotatedMethods = null;
        try {
            annotatedMethods = MethodIntrospector.selectMethods(bean.getClass(), (MethodIntrospector.MetadataLookup)new MethodIntrospector.MetadataLookup<CarpJobHandler>(){

                public CarpJobHandler inspect(Method method) {
                    return (CarpJobHandler)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, CarpJobHandler.class);
                }
            });
        }
        catch (Throwable ex) {
            log.error("@CarpJobHandler method jobhandler resolve error for bean: {}", (Object)beanName, (Object)ex);
        }
        if (!CollectionUtils.isEmpty((Map)annotatedMethods)) {
            for (Map.Entry entry : annotatedMethods.entrySet()) {
                this.register(beanName, bean, (Method)entry.getKey(), (CarpJobHandler)entry.getValue());
            }
        }
    }

    private void register(String beanName, Object bean, Method method, CarpJobHandler carpJobHandler) {
        if (this.registry.containsKey(carpJobHandler.value())) {
            throw new IllegalStateException("@CarpJobHandler annotation already exists for job: " + carpJobHandler.value() + " on bean: " + beanName);
        }
        this.registry.put(carpJobHandler.value(), new CarpJobMethod(bean, method, carpJobHandler));
    }

    private static class CarpJobMethod {
        private final Object bean;
        private final Method method;
        private final CarpJobHandler carpJobHandler;

        @Generated
        public Object getBean() {
            return this.bean;
        }

        @Generated
        public Method getMethod() {
            return this.method;
        }

        @Generated
        public CarpJobHandler getCarpJobHandler() {
            return this.carpJobHandler;
        }

        @Generated
        public CarpJobMethod(Object bean, Method method, CarpJobHandler carpJobHandler) {
            this.bean = bean;
            this.method = method;
            this.carpJobHandler = carpJobHandler;
        }
    }
}

