/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.redis.connection.FutureResult;
import org.springframework.lang.Nullable;

class LettuceResult<T, R>
extends FutureResult<CompletableFuture<T>> {
    private final boolean convertPipelineAndTxResults;

    LettuceResult(Future<T> resultHolder) {
        this(resultHolder, false, val -> val);
    }

    LettuceResult(Future<T> resultHolder, boolean convertPipelineAndTxResults, @Nullable Converter<T, R> converter) {
        this(resultHolder, () -> null, convertPipelineAndTxResults, converter);
    }

    LettuceResult(Future<T> resultHolder, Supplier<R> defaultReturnValue, boolean convertPipelineAndTxResults, @Nullable Converter<T, R> converter) {
        super((CompletableFuture)resultHolder, converter, defaultReturnValue);
        this.convertPipelineAndTxResults = convertPipelineAndTxResults;
    }

    @Override
    @Nullable
    public T get() {
        return ((CompletableFuture)this.getResultHolder()).join();
    }

    @Override
    public boolean conversionRequired() {
        return this.convertPipelineAndTxResults;
    }

    static class LettuceResultBuilder<T, R> {
        private final Future<T> response;
        private Converter<T, R> converter;
        private boolean convertPipelineAndTxResults = false;
        private Supplier<R> nullValueDefault = () -> null;

        LettuceResultBuilder(Future<T> response) {
            this.response = response;
            this.converter = source -> source;
        }

        static <T, R> LettuceResultBuilder<T, R> forResponse(Future<T> response) {
            return new LettuceResultBuilder<T, R>(response);
        }

        LettuceResultBuilder<T, R> mappedWith(Converter<T, R> converter) {
            this.converter = converter;
            return this;
        }

        LettuceResultBuilder<T, R> defaultNullTo(Supplier<R> supplier) {
            this.nullValueDefault = supplier;
            return this;
        }

        LettuceResultBuilder<T, R> convertPipelineAndTxResults(boolean flag) {
            this.convertPipelineAndTxResults = flag;
            return this;
        }

        LettuceResult<T, R> build() {
            return new LettuceResult<T, R>(this.response, this.nullValueDefault, this.convertPipelineAndTxResults, this.converter);
        }

        LettuceResult<T, R> buildStatusResult() {
            return new LettuceStatusResult(this.response);
        }
    }

    static class LettuceStatusResult<T, R>
    extends LettuceResult<T, R> {
        LettuceStatusResult(Future<T> resultHolder) {
            super(resultHolder);
            this.setStatus(true);
        }
    }
}

