/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.repository.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.DtoInstantiatingConverter;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.data.keyvalue.repository.query.KeyValuePartTreeQuery;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.redis.core.RedisKeyValueAdapter;
import org.springframework.data.redis.core.convert.RedisConverter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class RedisPartTreeQuery
extends KeyValuePartTreeQuery {
    private final RedisKeyValueAdapter adapter;

    public RedisPartTreeQuery(QueryMethod queryMethod, QueryMethodEvaluationContextProvider evaluationContextProvider, KeyValueOperations template, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        super(queryMethod, evaluationContextProvider, template, queryCreator);
        this.adapter = (RedisKeyValueAdapter)template.getKeyValueAdapter();
    }

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters);
        KeyValueQuery query = this.prepareQuery(parameters);
        ResultProcessor processor = this.getQueryMethod().getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        RedisConverter converter = this.adapter.getConverter();
        ResultProcessingConverter resultPostProcessor = new ResultProcessingConverter(processor, (MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>>)converter.getMappingContext(), converter.getEntityInstantiators());
        Object source = this.doExecute(parameters, query);
        return source != null ? processor.processResult(resultPostProcessor.convert(source)) : null;
    }

    static final class ResultProcessingConverter
    implements Converter<Object, Object> {
        private final ResultProcessor processor;
        private final MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> context;
        private final EntityInstantiators instantiators;

        public ResultProcessingConverter(ResultProcessor processor, MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> context, EntityInstantiators instantiators) {
            Assert.notNull((Object)processor, (String)"Processor must not be null!");
            Assert.notNull(context, (String)"MappingContext must not be null!");
            Assert.notNull((Object)instantiators, (String)"Instantiators must not be null!");
            this.processor = processor;
            this.context = context;
            this.instantiators = instantiators;
        }

        public Object convert(Object source) {
            if (source instanceof Set) {
                Set s = (Set)source;
                LinkedHashSet<Object> target = new LinkedHashSet<Object>(s.size());
                for (Object o : s) {
                    target.add(this.convert(o));
                }
                return target;
            }
            if (source instanceof Collection) {
                Collection c = (Collection)source;
                ArrayList<Object> target = new ArrayList<Object>(c.size());
                for (Object o : c) {
                    target.add(this.convert(o));
                }
                return target;
            }
            if (source instanceof Streamable) {
                Streamable s = (Streamable)source;
                return s.map(this::convert);
            }
            ReturnedType returnedType = this.processor.getReturnedType();
            if (ReflectionUtils.isVoid((Class)returnedType.getReturnedType())) {
                return null;
            }
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedType.getReturnedType())) {
                return source;
            }
            DtoInstantiatingConverter converter = new DtoInstantiatingConverter(returnedType.getReturnedType(), this.context, this.instantiators);
            return this.processor.processResult(source, (Converter)converter);
        }
    }
}

