/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core;

import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.CorrelationId;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.Precorrelation;
import org.zalando.logbook.RequestFilter;
import org.zalando.logbook.ResponseFilter;
import org.zalando.logbook.Sink;
import org.zalando.logbook.Strategy;
import org.zalando.logbook.attributes.AttributeExtractor;
import org.zalando.logbook.attributes.HttpAttributes;
import org.zalando.logbook.core.CachingHttpRequest;
import org.zalando.logbook.core.CachingHttpResponse;
import org.zalando.logbook.core.Stages;

final class DefaultLogbook
implements Logbook {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultLogbook.class);
    private final Predicate<HttpRequest> predicate;
    private final CorrelationId correlationId;
    private final RequestFilter requestFilter;
    private final ResponseFilter responseFilter;
    private final Strategy strategy;
    private final AttributeExtractor attributeExtractor;
    private final Sink sink;
    private final Clock clock = Clock.systemUTC();

    public Logbook.RequestWritingStage process(HttpRequest originalRequest) throws IOException {
        return this.process(originalRequest, this.strategy);
    }

    public Logbook.RequestWritingStage process(HttpRequest originalRequest, Strategy strategy) throws IOException {
        if (this.sink.isActive() && this.predicate.test(originalRequest)) {
            try {
                Precorrelation precorrelation = this.newPrecorrelation(originalRequest);
                HttpRequest processedRequest = strategy.process(originalRequest);
                HttpAttributes requestAttributes = this.extractAttributesOrEmpty(processedRequest);
                CachingHttpRequest request = new CachingHttpRequest(processedRequest, requestAttributes);
                HttpRequest filteredRequest = this.requestFilter.filter((HttpRequest)request);
                return new DefaultRequestWritingStage(strategy, precorrelation, processedRequest, filteredRequest);
            }
            catch (RuntimeException e) {
                log.warn("Unable to prepare request for logging. Will skip the request & response logging step.", (Throwable)e);
                return Stages.noop();
            }
        }
        return Stages.noop();
    }

    private HttpAttributes extractAttributesOrEmpty(HttpRequest request) {
        try {
            return this.attributeExtractor.extract(request);
        }
        catch (Exception e) {
            log.trace("AttributeExtractor throw exception while processing request: `{}`", (Object)e.getMessage());
            return HttpAttributes.EMPTY;
        }
    }

    private HttpAttributes extractAttributesOrEmpty(HttpRequest request, HttpResponse response) {
        try {
            return this.attributeExtractor.extract(request, response);
        }
        catch (Exception e) {
            log.trace("{} encountered error while extracting attributes: `{}`", (Object)this.attributeExtractor.getClass(), (Object)Optional.ofNullable(e.getCause()).orElse(e).getMessage());
            return HttpAttributes.EMPTY;
        }
    }

    private Precorrelation newPrecorrelation(HttpRequest request) {
        return new SimplePrecorrelation(this.correlationId.generate(request), this.clock);
    }

    @Generated
    public DefaultLogbook(Predicate<HttpRequest> predicate, CorrelationId correlationId, RequestFilter requestFilter, ResponseFilter responseFilter, Strategy strategy, AttributeExtractor attributeExtractor, Sink sink) {
        this.predicate = predicate;
        this.correlationId = correlationId;
        this.requestFilter = requestFilter;
        this.responseFilter = responseFilter;
        this.strategy = strategy;
        this.attributeExtractor = attributeExtractor;
        this.sink = sink;
    }

    private class DefaultRequestWritingStage
    implements Logbook.RequestWritingStage {
        private final Strategy strategy;
        private final Precorrelation precorrelation;
        private final HttpRequest processedRequest;
        private final HttpRequest filteredRequest;

        public Logbook.ResponseProcessingStage write() throws IOException {
            try {
                this.strategy.write(this.precorrelation, this.filteredRequest, DefaultLogbook.this.sink);
            }
            catch (RuntimeException e) {
                log.warn("Unable to log request. Will skip the request & response logging step.", (Throwable)e);
                return Stages.noop();
            }
            return this;
        }

        public Logbook.ResponseWritingStage process(HttpResponse originalResponse) throws IOException {
            HttpResponse processedResponse = this.strategy.process(this.filteredRequest, originalResponse);
            return () -> {
                try {
                    HttpAttributes responseAttributes = DefaultLogbook.this.extractAttributesOrEmpty(this.processedRequest, processedResponse);
                    CachingHttpResponse response = new CachingHttpResponse(processedResponse, responseAttributes);
                    HttpResponse filteredResponse = DefaultLogbook.this.responseFilter.filter((HttpResponse)response);
                    this.strategy.write(this.precorrelation.correlate(), this.filteredRequest, filteredResponse, DefaultLogbook.this.sink);
                }
                catch (RuntimeException e) {
                    log.warn("Unable to log response. Will skip the response logging step.", (Throwable)e);
                }
            };
        }

        @Generated
        public DefaultRequestWritingStage(Strategy strategy, Precorrelation precorrelation, HttpRequest processedRequest, HttpRequest filteredRequest) {
            this.strategy = strategy;
            this.precorrelation = precorrelation;
            this.processedRequest = processedRequest;
            this.filteredRequest = filteredRequest;
        }
    }

    static final class SimplePrecorrelation
    implements Precorrelation {
        private final String id;
        private final Clock clock;
        private final Instant start;

        SimplePrecorrelation(String id, Clock clock) {
            this.id = id;
            this.clock = clock;
            this.start = Instant.now(clock);
        }

        public Correlation correlate() {
            return new SimpleCorrelation(this.id, this.start, Instant.now(this.clock));
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public Instant getStart() {
            return this.start;
        }

        @Generated
        private Clock getClock() {
            return this.clock;
        }
    }

    static final class SimpleCorrelation
    implements Correlation {
        private final String id;
        private final Instant start;
        private final Instant end;
        private final Duration duration;

        SimpleCorrelation(String id, Instant start, Instant end) {
            this(id, start, end, Duration.between(start, end));
        }

        @Generated
        private SimpleCorrelation(String id, Instant start, Instant end, Duration duration) {
            this.id = id;
            this.start = start;
            this.end = end;
            this.duration = duration;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public Instant getStart() {
            return this.start;
        }

        @Generated
        public Instant getEnd() {
            return this.end;
        }

        @Generated
        public Duration getDuration() {
            return this.duration;
        }
    }
}

