/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.func.Func1;
import cn.hutool.core.lang.func.LambdaUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class EnumUtil {
    public static boolean isEnum(Class<?> clazz) {
        return Assert.notNull(clazz).isEnum();
    }

    public static boolean isEnum(Object obj) {
        return Assert.notNull(obj).getClass().isEnum();
    }

    public static String toString(Enum<?> e) {
        return null != e ? e.name() : null;
    }

    public static <E extends Enum<E>> E getEnumAt(Class<E> enumClass, int index) {
        if (null == enumClass) {
            return null;
        }
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        if (index < 0) {
            index = enumConstants.length + index;
        }
        return (E)(index >= 0 && index < enumConstants.length ? enumConstants[index] : null);
    }

    public static <E extends Enum<E>> E fromString(Class<E> enumClass, String value) {
        if (null == enumClass || StrUtil.isBlank(value)) {
            return null;
        }
        return Enum.valueOf(enumClass, value);
    }

    public static <E extends Enum<E>> E fromString(Class<E> enumClass, String value, E defaultValue) {
        return (E)((Enum)ObjectUtil.defaultIfNull(EnumUtil.fromStringQuietly(enumClass, value), defaultValue));
    }

    public static <E extends Enum<E>> E fromStringQuietly(Class<E> enumClass, String value) {
        try {
            return EnumUtil.fromString(enumClass, value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static <E extends Enum<E>> E likeValueOf(Class<E> enumClass, Object value) {
        if (null == enumClass || null == value) {
            return null;
        }
        if (value instanceof CharSequence) {
            value = value.toString().trim();
        }
        Field[] fields = ReflectUtil.getFields(enumClass);
        Enum[] enums = (Enum[])enumClass.getEnumConstants();
        for (Field field : fields) {
            String fieldName = field.getName();
            if (field.getType().isEnum() || "ENUM$VALUES".equals(fieldName) || "ordinal".equals(fieldName)) continue;
            for (Enum enumObj : enums) {
                if (!ObjectUtil.equal(value, ReflectUtil.getFieldValue((Object)enumObj, field))) continue;
                return (E)enumObj;
            }
        }
        return null;
    }

    public static List<String> getNames(Class<? extends Enum<?>> clazz) {
        if (null == clazz) {
            return null;
        }
        Enum<?>[] enums = clazz.getEnumConstants();
        if (null == enums) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(enums.length);
        for (Enum<?> e : enums) {
            list.add(e.name());
        }
        return list;
    }

    public static List<Object> getFieldValues(Class<? extends Enum<?>> clazz, String fieldName) {
        if (null == clazz || StrUtil.isBlank(fieldName)) {
            return null;
        }
        Enum<?>[] enums = clazz.getEnumConstants();
        if (null == enums) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(enums.length);
        for (Enum<?> e : enums) {
            list.add(ReflectUtil.getFieldValue(e, fieldName));
        }
        return list;
    }

    public static List<String> getFieldNames(Class<? extends Enum<?>> clazz) {
        Field[] fields;
        if (null == clazz) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Field field : fields = ReflectUtil.getFields(clazz)) {
            String name = field.getName();
            if (field.getType().isEnum() || name.contains("$VALUES") || "ordinal".equals(name) || names.contains(name)) continue;
            names.add(name);
        }
        return names;
    }

    public static <E extends Enum<E>> E getBy(Class<E> enumClass, Predicate<? super E> predicate) {
        if (null == enumClass || null == predicate) {
            return null;
        }
        return (E)((Enum)Arrays.stream(enumClass.getEnumConstants()).filter(predicate).findFirst().orElse(null));
    }

    public static <E extends Enum<E>, C> E getBy(Func1<E, C> condition, C value) {
        if (null == condition) {
            return null;
        }
        Class<E> implClass = LambdaUtil.getRealClass(condition);
        return (E)((Enum)Arrays.stream(implClass.getEnumConstants()).filter(constant -> ObjUtil.equals(condition.callWithRuntimeException(constant), value)).findAny().orElse(null));
    }

    public static <E extends Enum<E>, C> E getBy(Func1<E, C> condition, C value, E defaultEnum) {
        return (E)((Enum)ObjectUtil.defaultIfNull(EnumUtil.getBy(condition, value), defaultEnum));
    }

    public static <E extends Enum<E>, F, C> F getFieldBy(Func1<E, F> field, Function<E, C> condition, C value) {
        if (null == field || null == condition) {
            return null;
        }
        Class<E> implClass = LambdaUtil.getRealClass(field);
        return Arrays.stream(implClass.getEnumConstants()).filter(constant -> ObjUtil.equals(condition.apply(constant), value)).findFirst().map(field::callWithRuntimeException).orElse(null);
    }

    public static <E extends Enum<E>> LinkedHashMap<String, E> getEnumMap(Class<E> enumClass) {
        if (null == enumClass) {
            return null;
        }
        LinkedHashMap<String, Enum> map = new LinkedHashMap<String, Enum>();
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            map.put(e.name(), e);
        }
        return map;
    }

    public static Map<String, Object> getNameFieldMap(Class<? extends Enum<?>> clazz, String fieldName) {
        if (null == clazz || StrUtil.isBlank(fieldName)) {
            return null;
        }
        Enum<?>[] enums = clazz.getEnumConstants();
        if (null == enums) {
            return null;
        }
        HashMap<String, Object> map = MapUtil.newHashMap(enums.length, true);
        for (Enum<?> e : enums) {
            map.put(e.name(), ReflectUtil.getFieldValue(e, fieldName));
        }
        return map;
    }

    public static <E extends Enum<E>> boolean contains(Class<E> enumClass, String val) {
        LinkedHashMap<String, E> enumMap = EnumUtil.getEnumMap(enumClass);
        if (CollUtil.isEmpty(enumMap)) {
            return false;
        }
        return enumMap.containsKey(val);
    }

    public static <E extends Enum<E>> boolean notContains(Class<E> enumClass, String val) {
        return false == EnumUtil.contains(enumClass, val);
    }

    public static boolean equalsIgnoreCase(Enum<?> e, String val) {
        return StrUtil.equalsIgnoreCase(EnumUtil.toString(e), val);
    }

    public static boolean equals(Enum<?> e, String val) {
        return StrUtil.equals(EnumUtil.toString(e), val);
    }
}

