/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringBootVersion;
import org.springframework.cloud.configuration.CompatibilityPredicate;
import org.springframework.cloud.configuration.CompatibilityVerifier;
import org.springframework.cloud.configuration.VerificationResult;
import org.springframework.util.StringUtils;

class SpringBootVersionVerifier
implements CompatibilityVerifier {
    private static final Log log = LogFactory.getLog(SpringBootVersionVerifier.class);
    final Map<String, CompatibilityPredicate> ACCEPTED_VERSIONS = new HashMap<String, CompatibilityPredicate>(){
        {
            this.put("3.2", SpringBootVersionVerifier.this.is3_2());
            this.put("3.3", SpringBootVersionVerifier.this.is3_3());
        }
    };
    private final List<String> acceptedVersions;

    SpringBootVersionVerifier(List<String> acceptedVersions) {
        this.acceptedVersions = acceptedVersions;
    }

    @Override
    public VerificationResult verify() {
        boolean matches = this.springBootVersionMatches();
        if (matches) {
            return VerificationResult.compatible();
        }
        return VerificationResult.notCompatible(this.errorDescription(), this.action());
    }

    private Boolean bootVersionFromManifest(String s) {
        String version = this.getVersionFromManifest();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Version found in Boot manifest [" + version + "]"));
        }
        if (!StringUtils.hasText((String)version)) {
            log.info((Object)"Cannot check Boot version from manifest");
            return null;
        }
        return version.startsWith(SpringBootVersionVerifier.stripWildCardFromVersion(s));
    }

    String getVersionFromManifest() {
        return SpringBootVersion.getVersion();
    }

    CompatibilityPredicate is3_2() {
        return new CompatibilityPredicate(){

            public String toString() {
                return "Predicate for Boot 3.2";
            }

            @Override
            public boolean isCompatible() {
                try {
                    Class.forName("org.springframework.boot.autoconfigure.web.client.RestClientSsl");
                    return true;
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            }
        };
    }

    CompatibilityPredicate is3_3() {
        return new CompatibilityPredicate(){

            public String toString() {
                return "Predicate for Boot 3.3";
            }

            @Override
            public boolean isCompatible() {
                try {
                    Class.forName("org.springframework.boot.autoconfigure.ldap.PropertiesLdapConnectionDetails");
                    return true;
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            }
        };
    }

    private String errorDescription() {
        String versionFromManifest = this.getVersionFromManifest();
        if (StringUtils.hasText((String)versionFromManifest)) {
            return String.format("Spring Boot [%s] is not compatible with this Spring Cloud release train", versionFromManifest);
        }
        return "Spring Boot is not compatible with this Spring Cloud release train";
    }

    private String action() {
        return String.format("Change Spring Boot version to one of the following versions %s .\nYou can find the latest Spring Boot versions here [%s]. \nIf you want to learn more about the Spring Cloud Release train compatibility, you can visit this page [%s] and check the [Release Trains] section.\nIf you want to disable this check, just set the property [spring.cloud.compatibility-verifier.enabled=false]", this.acceptedVersions, "https://spring.io/projects/spring-boot#learn", "https://spring.io/projects/spring-cloud#overview");
    }

    private boolean springBootVersionMatches() {
        for (String acceptedVersion : this.acceptedVersions) {
            CompatibilityPredicate predicate;
            Boolean versionFromManifest = this.bootVersionFromManifest(acceptedVersion);
            if (versionFromManifest != null && versionFromManifest.booleanValue()) {
                return true;
            }
            if (versionFromManifest != null || (predicate = this.ACCEPTED_VERSIONS.get(SpringBootVersionVerifier.stripWildCardFromVersion(acceptedVersion))) == null || !predicate.isCompatible()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Predicate [" + predicate + "] was matched"));
            }
            return true;
        }
        return false;
    }

    static String stripWildCardFromVersion(String version) {
        if (version.endsWith(".x")) {
            return version.substring(0, version.indexOf(".x"));
        }
        return version;
    }
}

