/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.workflow.internal.engine.dispatch.handler.task;

import cn.sliew.carp.framework.dag.service.DagInstanceComplexService;
import cn.sliew.carp.framework.dag.service.DagStepService;
import cn.sliew.carp.module.workflow.api.service.WorkflowInstanceService;
import cn.sliew.carp.module.workflow.internal.engine.dispatch.event.WorkflowTaskInstanceEventDTO;
import cn.sliew.carp.module.workflow.internal.engine.dispatch.handler.task.WorkflowTaskInstanceEventListener;
import cn.sliew.carp.module.workflow.internal.statemachine.WorkflowInstanceStateMachine;
import cn.sliew.carp.module.workflow.internal.statemachine.WorkflowTaskInstanceStateMachine;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.redisson.api.RScheduledExecutorService;
import org.redisson.api.RedissonClient;
import org.redisson.api.WorkerOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractWorkflowTaskInstanceEventListener
implements WorkflowTaskInstanceEventListener,
InitializingBean,
BeanFactoryAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractWorkflowTaskInstanceEventListener.class);
    private BeanFactory beanFactory;
    protected RScheduledExecutorService executorService;
    @Autowired
    protected DagInstanceComplexService dagInstanceComplexService;
    @Autowired
    protected DagStepService dagStepService;
    @Autowired
    protected WorkflowInstanceService workflowInstanceService;
    @Autowired
    protected WorkflowInstanceStateMachine workflowInstanceStateMachine;
    @Autowired
    protected WorkflowTaskInstanceStateMachine stateMachine;
    @Autowired
    private RedissonClient redissonClient;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        this.executorService = this.redissonClient.getExecutorService("WorkflowTaskInstanceExecute");
        this.executorService.registerWorkers(WorkerOptions.defaults().workers(20).beanFactory(this.beanFactory));
    }

    @Override
    public void handleInternal(WorkflowTaskInstanceEventDTO event) {
        try {
            this.handleEventAsync(event);
        }
        catch (Throwable throwable) {
            this.onFailure(event.getWorkflowTaskInstanceId(), throwable);
        }
    }

    protected void onFailure(Long workflowTaskInstanceId, Throwable throwable) {
    }

    protected abstract CompletableFuture handleEventAsync(WorkflowTaskInstanceEventDTO var1);
}

