/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.workflow.internal.engine.dispatch.handler.workflow;

import cn.sliew.carp.framework.common.dict.workflow.WorkflowExecuteType;
import cn.sliew.carp.framework.common.dict.workflow.WorkflowInstanceEvent;
import cn.sliew.carp.framework.dag.algorithm.DAG;
import cn.sliew.carp.framework.dag.service.DagInstanceService;
import cn.sliew.carp.module.workflow.api.engine.domain.instance.WorkflowInstance;
import cn.sliew.carp.module.workflow.api.engine.domain.instance.WorkflowTaskInstance;
import cn.sliew.carp.module.workflow.api.service.convert.WorkflowExecutionGraphConvert;
import cn.sliew.carp.module.workflow.internal.engine.dispatch.event.WorkflowInstanceEventDTO;
import cn.sliew.carp.module.workflow.internal.engine.dispatch.handler.workflow.AbstractWorkflowInstanceEventListener;
import cn.sliew.carp.module.workflow.internal.executor.WorkflowInstanceExecutorManager;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowInstanceDeployEventListener
extends AbstractWorkflowInstanceEventListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowInstanceDeployEventListener.class);
    @Autowired
    private DagInstanceService dagInstanceService;
    @Autowired
    private WorkflowInstanceExecutorManager workflowInstanceExecutorManager;

    public WorkflowInstanceEvent getType() {
        return WorkflowInstanceEvent.COMMAND_DEPLOY;
    }

    @Override
    protected CompletableFuture handleEventAsync(WorkflowInstanceEventDTO event) {
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> this.run(event));
        future.whenCompleteAsync((unused, throwable) -> {
            if (throwable != null) {
                log.error(throwable.getMessage(), throwable);
                this.onFailure(event.getWorkflowInstanceId(), (Throwable)throwable);
            }
        });
        return future;
    }

    private void run(WorkflowInstanceEventDTO event) {
        this.dagInstanceService.updateStatus(event.getWorkflowInstanceId(), event.getState().getValue(), event.getNextState().getValue());
        WorkflowInstance workflowInstance = this.workflowInstanceService.getGraph(event.getWorkflowInstanceId());
        DAG dag = WorkflowExecutionGraphConvert.INSTANCE.toDto(workflowInstance.getGraph());
        if (dag.nodes().size() == 0) {
            this.stateMachine.onSuccess(workflowInstance);
            return;
        }
        this.workflowInstanceExecutorManager.execute(WorkflowExecuteType.EXECUTE, workflowInstance, (DAG<WorkflowTaskInstance>)dag);
    }
}

