/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.workflow.internal.engine.dispatch.handler.workflow;

import cn.sliew.carp.framework.common.dict.workflow.WorkflowInstanceEvent;
import cn.sliew.carp.framework.common.dict.workflow.WorkflowInstanceState;
import cn.sliew.carp.framework.dag.service.DagInstanceService;
import cn.sliew.carp.framework.dag.service.dto.DagInstanceDTO;
import cn.sliew.carp.module.workflow.internal.engine.dispatch.event.WorkflowInstanceEventDTO;
import cn.sliew.carp.module.workflow.internal.engine.dispatch.handler.workflow.AbstractWorkflowInstanceEventListener;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowInstanceSuccessEventListener
extends AbstractWorkflowInstanceEventListener {
    @Autowired
    private DagInstanceService dagInstanceService;

    public WorkflowInstanceEvent getType() {
        return WorkflowInstanceEvent.PROCESS_SUCCESS;
    }

    @Override
    protected CompletableFuture handleEventAsync(WorkflowInstanceEventDTO event) {
        return CompletableFuture.runAsync(new SuccessRunner(event.getWorkflowInstanceId()));
    }

    private class SuccessRunner
    implements Runnable,
    Serializable {
        private Long workflowInstanceId;

        public SuccessRunner(Long workflowInstanceId) {
            this.workflowInstanceId = workflowInstanceId;
        }

        @Override
        public void run() {
            DagInstanceDTO dagInstanceUpdateParam = new DagInstanceDTO();
            dagInstanceUpdateParam.setId(this.workflowInstanceId);
            dagInstanceUpdateParam.setStatus(WorkflowInstanceState.SUCCESS.getValue());
            dagInstanceUpdateParam.setEndTime(new Date());
            WorkflowInstanceSuccessEventListener.this.dagInstanceService.update(dagInstanceUpdateParam);
        }
    }
}

