/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.http.sync.job.jst;

import cn.sliew.carp.module.http.sync.framework.model.AbstractJob;
import cn.sliew.carp.module.http.sync.framework.model.RootTask;
import cn.sliew.carp.module.http.sync.framework.model.SplitManager;
import cn.sliew.carp.module.http.sync.framework.model.SyncOffsetManager;
import cn.sliew.carp.module.http.sync.framework.model.internal.SimpleJobContext;
import cn.sliew.carp.module.http.sync.job.enums.JstJob;
import cn.sliew.carp.module.http.sync.job.jst.JstJobParam;
import cn.sliew.carp.module.http.sync.job.remote.JstRemoteService;
import cn.sliew.carp.module.http.sync.job.repository.entity.jst.JstAuth;
import cn.sliew.carp.module.http.sync.job.repository.mapper.jst.JstAuthMapper;
import cn.sliew.carp.module.http.sync.job.task.jst.AbstractJstRootTask;
import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.common.util.JacksonUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.actor.typed.SpawnProtocol;

public abstract class AbstractJstJob
extends AbstractJob {
    protected final JstRemoteService jstRemoteService;
    private final JstAuthMapper jstAuthMapper;

    public AbstractJstJob(ActorSystem<SpawnProtocol.Command> actorSystem, SyncOffsetManager syncOffsetManager, SplitManager splitManager, JstRemoteService jstRemoteService, JstAuthMapper jstAuthMapper) {
        super(actorSystem, syncOffsetManager, splitManager);
        this.jstRemoteService = jstRemoteService;
        this.jstAuthMapper = jstAuthMapper;
    }

    public String getJobName() {
        return String.format("%s.%s.%s", this.getJstJob().getGroup().getGroup(), this.getJstJob().getApi().getApi(), this.getJstJob().getType().getType());
    }

    protected SimpleJobContext buildJobContext() {
        SimpleJobContext jobContext = super.buildJobContext();
        JstJob jstJob = this.getJstJob();
        jobContext.setGroup(jstJob.getGroup().getGroup());
        jobContext.setJob(jstJob.getApi().getApi());
        jobContext.setSubJob(jstJob.getType().getType());
        return jobContext;
    }

    protected RootTask buildRootTask(Object param) {
        JstJobParam jstJobParam = (JstJobParam)JacksonUtil.parseJsonString((String)((String)param), JstJobParam.class);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(JstAuth.class).eq(JstAuth::getAppKey, (Object)jstJobParam.getAppKey())).eq(JstAuth::getCompany, (Object)jstJobParam.getCompany());
        JstAuth jstAuth = (JstAuth)((Object)this.jstAuthMapper.selectOne((Wrapper)queryWrapper));
        Ensures.checkState((jstAuth != null ? 1 : 0) != 0);
        return this.buildJstRootTask(jstAuth);
    }

    protected abstract JstJob getJstJob();

    protected abstract AbstractJstRootTask buildJstRootTask(JstAuth var1);
}

