/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.http.sync.framework.model;

import cn.sliew.carp.module.http.sync.framework.model.DefaultJobProcessor;
import cn.sliew.carp.module.http.sync.framework.model.Job;
import cn.sliew.carp.module.http.sync.framework.model.JobProcessor;
import cn.sliew.carp.module.http.sync.framework.model.RootTask;
import cn.sliew.carp.module.http.sync.framework.model.SplitManager;
import cn.sliew.carp.module.http.sync.framework.model.SyncOffsetManager;
import cn.sliew.carp.module.http.sync.framework.model.internal.ProcessResult;
import cn.sliew.carp.module.http.sync.framework.model.internal.SimpleJobContext;
import cn.sliew.milky.common.exception.Rethrower;
import cn.sliew.milky.common.util.JacksonUtil;
import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.actor.typed.SpawnProtocol;
import org.apache.pekko.japi.Pair;
import org.apache.pekko.japi.function.Function;
import org.apache.pekko.japi.function.Procedure;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.KillSwitches;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.UniformFanInShape;
import org.apache.pekko.stream.UniformFanOutShape;
import org.apache.pekko.stream.UniqueKillSwitch;
import org.apache.pekko.stream.javadsl.Flow;
import org.apache.pekko.stream.javadsl.GraphDSL;
import org.apache.pekko.stream.javadsl.Keep;
import org.apache.pekko.stream.javadsl.MergeSequence;
import org.apache.pekko.stream.javadsl.Partition;
import org.apache.pekko.stream.javadsl.Sink;
import org.apache.pekko.stream.javadsl.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJob
implements Job {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractJob.class);
    protected ActorSystem<SpawnProtocol.Command> actorSystem;
    protected SyncOffsetManager syncOffsetManager;
    protected SplitManager splitManager;

    public AbstractJob(ActorSystem<SpawnProtocol.Command> actorSystem, SyncOffsetManager syncOffsetManager, SplitManager splitManager) {
        this.actorSystem = actorSystem;
        this.syncOffsetManager = syncOffsetManager;
        this.splitManager = splitManager;
    }

    @Override
    public void process(String param) {
        this.doExecute(param);
    }

    protected void doExecute(Object param) {
        SimpleJobContext context = this.buildJobContext();
        JobProcessor processor = this.buildJobProcessor(context);
        RootTask rootTask = this.buildRootTask(param);
        Source source = Source.single((Object)rootTask).mapConcat((Function & Serializable)root -> processor.map(root)).viaMat(KillSwitches.single(), Keep.right());
        Flow process = Flow.create().map((Function & Serializable)subTask -> processor.process(subTask)).mapAsync(1, (Function & Serializable)future -> future);
        Flow subTasks = Flow.fromGraph((Graph)GraphDSL.create((Function & Serializable)b -> {
            int concurrency = context.getSubTaskParallelism();
            UniformFanOutShape partition = (UniformFanOutShape)b.add(Partition.create((int)concurrency, (Function & Serializable)subTask -> Math.toIntExact(subTask.getIdentifier()) % concurrency));
            UniformFanInShape merge = (UniformFanInShape)b.add(MergeSequence.create((int)concurrency, (Function & Serializable)result -> result.getSubTask().getIdentifier()));
            for (int i = 0; i < concurrency; ++i) {
                b.from(partition.out(i)).via((FlowShape)b.add((Graph)process.async())).viaFanIn(merge);
            }
            return FlowShape.of((Inlet)partition.in(), (Outlet)merge.out());
        }));
        Pair pair = (Pair)source.via((Graph)subTasks).log(this.getJobName()).toMat((Graph)Sink.foreach((Procedure & Serializable)result -> processor.reduce((ProcessResult)result)), Keep.both()).run(this.actorSystem);
        UniqueKillSwitch killSwitch = (UniqueKillSwitch)pair.first();
        try {
            ((CompletionStage)pair.second()).toCompletableFuture().get(1L, TimeUnit.HOURS);
        }
        catch (Exception e) {
            log.error("job \u6267\u884c\u5f02\u5e38, job: {}, param: {}", (Object)this.getJobName(), (Object)JacksonUtil.toJsonString((Object)param));
            killSwitch.abort((Throwable)e);
            Rethrower.throwAs((Throwable)e);
        }
    }

    public abstract String getJobName();

    protected SimpleJobContext buildJobContext() {
        SimpleJobContext jobContext = new SimpleJobContext();
        jobContext.setActorSystem(this.actorSystem);
        jobContext.setSyncOffsetManager(this.syncOffsetManager);
        jobContext.setSplitManager(this.splitManager);
        return jobContext;
    }

    protected JobProcessor buildJobProcessor(SimpleJobContext context) {
        return new DefaultJobProcessor(context);
    }

    protected abstract RootTask buildRootTask(Object var1);
}

