/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.http.sync.framework.model;

import cn.sliew.carp.module.http.sync.framework.model.AbstractSubTask;
import cn.sliew.carp.module.http.sync.framework.model.RootTask;
import cn.sliew.carp.module.http.sync.framework.model.SplitManager;
import cn.sliew.carp.module.http.sync.framework.model.SyncOffsetManager;
import cn.sliew.carp.module.http.sync.framework.model.internal.SimpleJobContext;
import cn.sliew.carp.module.http.sync.framework.repository.entity.JobSyncOffset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.pekko.japi.Pair;

public abstract class AbstractRootTask<Sub extends AbstractSubTask>
implements RootTask<SimpleJobContext, Sub> {
    private Long rootTaskId;

    public AbstractRootTask(Long rootTaskId) {
        this.rootTaskId = rootTaskId;
    }

    @Override
    public Long getIdentifier() {
        return this.rootTaskId;
    }

    @Override
    public List<Sub> split(SimpleJobContext context) {
        SyncOffsetManager syncOffsetManager = context.getSyncOffsetManager();
        JobSyncOffset syncOffset = syncOffsetManager.getSyncOffset(context);
        SplitManager splitManager = context.getSplitManager();
        Optional<Duration> optional = splitManager.getGradients().stream().filter(gradient -> splitManager.supportSplit(syncOffset.getSyncOffset(), context.getFinalSyncOffset(), (Duration)gradient)).findFirst();
        Duration gradient2 = null;
        if (optional.isEmpty()) {
            boolean backupSupport = splitManager.supportSplit(syncOffset.getSyncOffset(), context.getFinalSyncOffset(), splitManager.getBackoffGradient());
            if (backupSupport) {
                gradient2 = splitManager.getBackoffGradient();
            }
        } else {
            gradient2 = optional.get();
        }
        if (gradient2 == null) {
            return Collections.emptyList();
        }
        List<Pair<String, String>> splits = context.getSplitManager().split(syncOffset.getSyncOffset(), context.getFinalSyncOffset(), gradient2, context.getSubTaskBatchSize());
        ArrayList<AbstractSubTask> subs = new ArrayList<AbstractSubTask>();
        for (int i = 0; i < splits.size(); ++i) {
            Pair<String, String> pair = splits.get(i);
            subs.add((AbstractSubTask)this.build(Long.valueOf(i), (String)pair.first(), (String)pair.second()));
        }
        return subs;
    }
}

