/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.http.sync.framework.model;

import cn.sliew.carp.module.http.sync.framework.model.AbstractRootTask;
import cn.sliew.carp.module.http.sync.framework.model.FetchResult;
import cn.sliew.carp.module.http.sync.framework.model.SubTask;
import cn.sliew.carp.module.http.sync.framework.model.internal.ProcessResult;
import cn.sliew.carp.module.http.sync.framework.model.internal.SimpleJobContext;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.japi.function.Procedure;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.javadsl.Sink;
import org.apache.pekko.stream.javadsl.Source;
import scala.concurrent.ExecutionContext;

public abstract class AbstractSubTask<Root extends AbstractRootTask, Request, Response>
implements SubTask<SimpleJobContext, Root> {
    private final Long subTaskId;
    private final Root rootTask;
    private final String startSyncOffset;
    private final String endSyncOffset;

    public AbstractSubTask(Long subTaskId, Root rootTask, String startSyncOffset, String endSyncOffset) {
        this.subTaskId = subTaskId;
        this.rootTask = rootTask;
        this.startSyncOffset = startSyncOffset;
        this.endSyncOffset = endSyncOffset;
    }

    @Override
    public Long getIdentifier() {
        return this.subTaskId;
    }

    @Override
    public Root getRootTask() {
        return this.rootTask;
    }

    @Override
    public String getStartSyncOffset() {
        return this.startSyncOffset;
    }

    @Override
    public String getEndSyncOffset() {
        return this.endSyncOffset;
    }

    @Override
    public CompletableFuture<ProcessResult> execute(SimpleJobContext context) {
        ActorSystem actorSystem = context.getActorSystem();
        Sink sink = Sink.foreachParallel((int)10, (Procedure & Serializable)data -> this.persistData(context, data.getRequest(), data.getResponse()), (ExecutionContext)actorSystem.executionContext());
        Source<FetchResult<Request, Response>, ?> source = this.fetch(context);
        CompletionStage completionStage = (CompletionStage)source.runWith((Graph)sink, (ClassicActorSystemProvider)actorSystem);
        return completionStage.thenApply(done -> ProcessResult.success(this)).toCompletableFuture();
    }

    protected abstract Source<FetchResult<Request, Response>, ?> fetch(SimpleJobContext var1);

    protected abstract Request buildFirstRequest(SimpleJobContext var1);

    protected abstract Response requestRemote(SimpleJobContext var1, Request var2);

    protected abstract void persistData(SimpleJobContext var1, Request var2, Response var3);
}

