/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.http.sync.framework.model;

import cn.sliew.carp.module.http.sync.framework.model.JobContext;
import cn.sliew.carp.module.http.sync.framework.model.JobProcessor;
import cn.sliew.carp.module.http.sync.framework.model.RootTask;
import cn.sliew.carp.module.http.sync.framework.model.SubTask;
import cn.sliew.carp.module.http.sync.framework.model.SyncOffsetJobContext;
import cn.sliew.carp.module.http.sync.framework.model.internal.ProcessResult;
import cn.sliew.milky.common.exception.Rethrower;
import cn.sliew.milky.common.util.JacksonUtil;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJobProcessor<Context extends SyncOffsetJobContext, Root extends RootTask, Sub extends SubTask>
implements JobProcessor<Context, Root, Sub> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultJobProcessor.class);
    private final Context context;

    public DefaultJobProcessor(Context context) {
        this.context = context;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public List<Sub> map(Root rootTask) {
        return rootTask.split((JobContext)this.getContext());
    }

    @Override
    public CompletableFuture<ProcessResult> process(Sub subTask) {
        return subTask.execute(this.context);
    }

    @Override
    public ProcessResult reduce(ProcessResult result) {
        if (!result.isSuccess()) {
            log.error("group: {}, job: {}, subJob: {}, \u5b50\u4efb\u52a1\u5904\u7406\u5931\u8d25: {}!", new Object[]{this.context.getGroup(), this.context.getJob(), this.context.getSubJob().orElse(null), result.getMessage(), result.getThrowable()});
            if (result.getThrowable() != null) {
                Rethrower.throwAs((Throwable)result.getThrowable());
            }
            throw new RuntimeException(result.getMessage());
        }
        SubTask subTask = result.getSubTask();
        log.debug("group: {}, job: {}, subJob: {}, {}-{}, \u5b50\u4efb\u52a1\u5904\u7406\u6210\u529f! \u5b50\u4efb\u52a1\u8be6\u60c5: {}", new Object[]{this.context.getGroup(), this.context.getJob(), this.context.getSubJob().orElse(null), subTask.getRootTask().getIdentifier(), subTask.getIdentifier(), JacksonUtil.toJsonString((Object)subTask)});
        this.context.getSyncOffsetManager().updateSyncOffset(this.context, subTask.getEndSyncOffset());
        return ProcessResult.success(result.getSubTask());
    }
}

