/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.http.sync.framework.model;

import cn.sliew.carp.module.http.sync.framework.model.SyncOffsetManager;
import cn.sliew.carp.module.http.sync.framework.model.internal.SimpleJobContext;
import cn.sliew.carp.module.http.sync.framework.repository.entity.JobSyncOffset;
import cn.sliew.carp.module.http.sync.framework.repository.mapper.JobSyncOffsetMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Component;

@Component
public class DefaultSyncOffsetManager
implements SyncOffsetManager<SimpleJobContext> {
    private JobSyncOffsetMapper jobSyncOffsetMapper;

    public DefaultSyncOffsetManager(JobSyncOffsetMapper jobSyncOffsetMapper) {
        this.jobSyncOffsetMapper = jobSyncOffsetMapper;
    }

    @Override
    public JobSyncOffset getSyncOffset(SimpleJobContext context) {
        LambdaQueryWrapper<JobSyncOffset> queryWrapper = this.buildQueryWrapper(context);
        JobSyncOffset syncOffset = (JobSyncOffset)((Object)this.jobSyncOffsetMapper.selectOne((Wrapper)queryWrapper));
        if (syncOffset != null) {
            return syncOffset;
        }
        this.initSyncOffset(context);
        return this.getSyncOffset(context);
    }

    @Override
    public void initSyncOffset(SimpleJobContext context) {
        JobSyncOffset record = new JobSyncOffset();
        record.setGroup(context.getGroup());
        record.setJob(context.getJob());
        context.getSubJob().ifPresent(subJob -> record.setSubJob((String)subJob));
        record.setSyncOffset(context.getInitialSyncOffset());
        record.setCreator("sync-offset-manager");
        record.setEditor("sync-offset-manager");
        this.jobSyncOffsetMapper.insert((Object)record);
    }

    @Override
    public void updateSyncOffset(SimpleJobContext context, String syncOffset) {
        JobSyncOffset jobSyncOffset = this.getSyncOffset(context);
        LambdaQueryWrapper<JobSyncOffset> queryWrapper = this.buildQueryWrapper(context);
        JobSyncOffset record = new JobSyncOffset();
        record.setGroup(context.getGroup());
        record.setJob(context.getJob());
        context.getSubJob().ifPresent(subJob -> record.setSubJob((String)subJob));
        record.setLastSyncOffset(jobSyncOffset.getSyncOffset());
        record.setSyncOffset(syncOffset);
        record.setEditor("sync-offset-manager");
        this.jobSyncOffsetMapper.update((Object)record, (Wrapper)queryWrapper);
    }

    @Override
    public void resetSyncOffset(SimpleJobContext context) {
        LambdaQueryWrapper<JobSyncOffset> queryWrapper = this.buildQueryWrapper(context);
        this.jobSyncOffsetMapper.delete((Wrapper)queryWrapper);
        this.initSyncOffset(context);
    }

    protected LambdaQueryWrapper<JobSyncOffset> buildQueryWrapper(SimpleJobContext context) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(JobSyncOffset.class).eq(JobSyncOffset::getGroup, (Object)context.getGroup())).eq(JobSyncOffset::getJob, (Object)context.getJob());
        if (context.getSubJob().isPresent()) {
            queryWrapper.eq(JobSyncOffset::getSubJob, (Object)context.getSubJob().get());
        }
        if (context.getAccount().isPresent()) {
            queryWrapper.eq(JobSyncOffset::getAccount, (Object)context.getAccount().get());
        }
        if (context.getSubAccount().isPresent()) {
            queryWrapper.eq(JobSyncOffset::getSubAccount, (Object)context.getSubAccount().get());
        }
        return queryWrapper;
    }
}

