/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.http.sync.framework.model;

import cn.hutool.core.date.DateUtil;
import cn.sliew.carp.module.http.sync.framework.util.GradientUtil;
import cn.sliew.carp.module.http.sync.framework.util.SyncOffsetHelper;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.pekko.japi.Pair;

public interface SplitManager {
    public List<Duration> getGradients();

    default public boolean supportSplit(String startSyncOffset, String endSyncOffset, Duration gradient) {
        LocalDateTime startTime = LocalDateTime.parse(startSyncOffset, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LocalDateTime endTime = LocalDateTime.parse(endSyncOffset, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        return SyncOffsetHelper.supportSplit(startTime, endTime, gradient);
    }

    default public List<Pair<String, String>> split(String startSyncOffset, String endSyncOffset, Duration gradient, int total) {
        LocalDateTime startTime = LocalDateTime.parse(startSyncOffset, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LocalDateTime endTime = LocalDateTime.parse(endSyncOffset, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        return SyncOffsetHelper.split(startTime, endTime, gradient, total).stream().map(pair -> Pair.create((Object)DateUtil.format((LocalDateTime)((LocalDateTime)pair.first()), (String)"yyyy-MM-dd HH:mm:ss"), (Object)DateUtil.format((LocalDateTime)((LocalDateTime)pair.first()), (String)"yyyy-MM-dd HH:mm:ss"))).collect(Collectors.toUnmodifiableList());
    }

    default public Duration getBackoffGradient() {
        return GradientUtil.MIN_GRADIENT;
    }
}

