/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.datasource.service.convert;

import cn.sliew.carp.framework.common.codec.CodecUtil;
import cn.sliew.carp.framework.common.collection.PropValuePair;
import cn.sliew.carp.framework.common.convert.BaseConvert;
import cn.sliew.carp.module.datasource.repository.entity.DsInfo;
import cn.sliew.carp.module.datasource.service.dto.DsInfoDTO;
import cn.sliew.carp.module.datasource.service.dto.DsTypeDTO;
import cn.sliew.milky.common.util.JacksonUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE)
public interface DsInfoConvert
extends BaseConvert<DsInfo, DsInfoDTO> {
    public static final DsInfoConvert INSTANCE = (DsInfoConvert)Mappers.getMapper(DsInfoConvert.class);

    default public DsInfoDTO toDto(DsInfo entity) {
        DsInfoDTO dto = new DsInfoDTO();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)dto));
        DsTypeDTO dsType = new DsTypeDTO();
        dsType.setId(entity.getDsTypeId());
        dto.setDsType(dsType);
        if (StringUtils.hasText((String)entity.getProps())) {
            String jsonProps = CodecUtil.decodeFromBase64((String)entity.getProps());
            dto.setProps((Map)JacksonUtil.parseJsonString((String)jsonProps, (TypeReference)new TypeReference<Map<String, Object>>(){}));
        }
        if (StringUtils.hasText((String)entity.getAdditionalProps())) {
            String jsonAdditionalProps = CodecUtil.decodeFromBase64((String)entity.getAdditionalProps());
            dto.setAdditionalProps(JacksonUtil.parseJsonArray((String)jsonAdditionalProps, PropValuePair.class));
        }
        return dto;
    }

    default public DsInfo toDo(DsInfoDTO dto) {
        DsInfo record = new DsInfo();
        BeanUtils.copyProperties((Object)((Object)dto), (Object)((Object)record));
        record.setDsTypeId(dto.getDsType().getId());
        if (!CollectionUtils.isEmpty(dto.getProps())) {
            String jsonProps = JacksonUtil.toJsonString(dto.getProps());
            record.setProps(CodecUtil.encodeToBase64((String)jsonProps));
        }
        if (!CollectionUtils.isEmpty(dto.getAdditionalProps())) {
            String jsonAdditionalProps = JacksonUtil.toJsonString(dto.getAdditionalProps());
            record.setAdditionalProps(CodecUtil.encodeToBase64((String)jsonAdditionalProps));
        }
        return record;
    }
}

