/*
 * Decompiled with CFR 0.152.
 */
package org.lmdbjava;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.lmdbjava.Cursor;
import org.lmdbjava.Dbi;
import org.lmdbjava.GetOp;
import org.lmdbjava.KeyRange;
import org.lmdbjava.KeyRangeType;
import org.lmdbjava.PutFlags;
import org.lmdbjava.Txn;

public final class CursorIterable<T>
implements Iterable<KeyVal<T>>,
AutoCloseable {
    private final Comparator<T> comparator;
    private final Cursor<T> cursor;
    private final KeyVal<T> entry;
    private boolean iteratorReturned;
    private final KeyRange<T> range;
    private State state = State.REQUIRES_INITIAL_OP;

    CursorIterable(Txn<T> txn, Dbi<T> dbi, KeyRange<T> range, Comparator<T> comparator) {
        this.cursor = dbi.openCursor(txn);
        this.range = range;
        this.comparator = comparator;
        this.entry = new KeyVal();
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    @Override
    public Iterator<KeyVal<T>> iterator() {
        if (this.iteratorReturned) {
            throw new IllegalStateException("Iterator can only be returned once");
        }
        this.iteratorReturned = true;
        return new Iterator<KeyVal<T>>(){

            @Override
            public boolean hasNext() {
                while (CursorIterable.this.state != State.RELEASED && CursorIterable.this.state != State.TERMINATED) {
                    CursorIterable.this.update();
                }
                return CursorIterable.this.state == State.RELEASED;
            }

            @Override
            public KeyVal<T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                CursorIterable.this.state = State.REQUIRES_NEXT_OP;
                return CursorIterable.this.entry;
            }

            @Override
            public void remove() {
                CursorIterable.this.cursor.delete(new PutFlags[0]);
            }
        };
    }

    private void executeCursorOp(KeyRangeType.CursorOp op) {
        boolean found;
        switch (op) {
            case FIRST: {
                found = this.cursor.first();
                break;
            }
            case LAST: {
                found = this.cursor.last();
                break;
            }
            case NEXT: {
                found = this.cursor.next();
                break;
            }
            case PREV: {
                found = this.cursor.prev();
                break;
            }
            case GET_START_KEY: {
                found = this.cursor.get(this.range.getStart(), GetOp.MDB_SET_RANGE);
                break;
            }
            case GET_START_KEY_BACKWARD: {
                found = this.cursor.get(this.range.getStart(), GetOp.MDB_SET_RANGE) || this.cursor.last();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown cursor operation");
            }
        }
        this.entry.setK(found ? (Object)this.cursor.key() : null);
        this.entry.setV(found ? (Object)this.cursor.val() : null);
    }

    private void executeIteratorOp() {
        KeyRangeType.IteratorOp op = this.range.getType().iteratorOp(this.range.getStart(), this.range.getStop(), this.entry.key(), this.comparator);
        switch (op) {
            case CALL_NEXT_OP: {
                this.executeCursorOp(this.range.getType().nextOp());
                this.state = State.REQUIRES_ITERATOR_OP;
                break;
            }
            case TERMINATE: {
                this.state = State.TERMINATED;
                break;
            }
            case RELEASE: {
                this.state = State.RELEASED;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown operation");
            }
        }
    }

    private void update() {
        switch (this.state) {
            case REQUIRES_INITIAL_OP: {
                this.executeCursorOp(this.range.getType().initialOp());
                this.state = State.REQUIRES_ITERATOR_OP;
                break;
            }
            case REQUIRES_NEXT_OP: {
                this.executeCursorOp(this.range.getType().nextOp());
                this.state = State.REQUIRES_ITERATOR_OP;
                break;
            }
            case REQUIRES_ITERATOR_OP: {
                this.executeIteratorOp();
                break;
            }
            case TERMINATED: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state");
            }
        }
    }

    static enum State {
        REQUIRES_INITIAL_OP,
        REQUIRES_NEXT_OP,
        REQUIRES_ITERATOR_OP,
        RELEASED,
        TERMINATED;

    }

    public static final class KeyVal<T> {
        private T k;
        private T v;

        public T key() {
            return this.k;
        }

        public T val() {
            return this.v;
        }

        void setK(T key) {
            this.k = key;
        }

        void setV(T val) {
            this.v = val;
        }
    }
}

