/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.scheduler.quartz.service;

import cn.sliew.carp.module.scheduler.service.dto.ScheduleJobInstanceDTO;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public final class QuartzUtil
extends Enum<QuartzUtil> {
    private static final String JOB_PREFIX = "job";
    private static final String JOB_GROUP_PREFIX = "jobGrp";
    private static final String TRIGGER_PREFIX = "trigger";
    private static final String TRIGGER_GROUP_PREFIX = "triggerGrp";
    public static final String JOB_INSTANCE_ATTR = "CARP_JOB_INSTANCE_ID";
    private static final /* synthetic */ QuartzUtil[] $VALUES;

    public static QuartzUtil[] values() {
        return (QuartzUtil[])$VALUES.clone();
    }

    public static QuartzUtil valueOf(String name) {
        return Enum.valueOf(QuartzUtil.class, name);
    }

    public static JobDataMap buildDataMap(ScheduleJobInstanceDTO instance) {
        return new JobDataMap(Map.of(JOB_INSTANCE_ATTR, instance.getId()));
    }

    public static JobKey getJobKey(ScheduleJobInstanceDTO instance) {
        String jobGroup = String.format("%s_%s", JOB_GROUP_PREFIX, instance.getJobConfig().getJobGroup().getNamespace());
        String jobName = String.format("%s_%s", JOB_PREFIX, instance.getJobConfig().getName());
        return new JobKey(jobName, jobGroup);
    }

    public static TriggerKey getTriggerKey(ScheduleJobInstanceDTO instance) {
        String triggerGroup = String.format("%s_%s", TRIGGER_GROUP_PREFIX, instance.getJobConfig().getJobGroup().getNamespace());
        String triggerName = String.format("%s_%s", TRIGGER_PREFIX, instance.getId());
        return TriggerKey.triggerKey((String)triggerName, (String)triggerGroup);
    }

    public static Trigger getTrigger(ScheduleJobInstanceDTO instance) {
        TriggerBuilder<Trigger> builder = QuartzUtil.buildTrigger(instance);
        return builder.withSchedule(QuartzUtil.buildCronSchedule(instance)).build();
    }

    public static Trigger getTriggerOnce(ScheduleJobInstanceDTO instance) {
        TriggerBuilder<Trigger> builder = QuartzUtil.buildTrigger(instance);
        return builder.withSchedule(QuartzUtil.buildOnceSchedule(instance)).build();
    }

    private static TriggerBuilder<Trigger> buildTrigger(ScheduleJobInstanceDTO instance) {
        TriggerBuilder builder = TriggerBuilder.newTrigger().withIdentity(QuartzUtil.getTriggerKey(instance));
        if (Objects.nonNull(instance.getStartTime())) {
            builder.startAt(instance.getStartTime());
        }
        if (Objects.nonNull(instance.getEndTime())) {
            builder.endAt(instance.getEndTime());
        }
        return builder;
    }

    private static ScheduleBuilder buildCronSchedule(ScheduleJobInstanceDTO instance) {
        return CronScheduleBuilder.cronSchedule((String)instance.getCron()).inTimeZone(TimeZone.getTimeZone(instance.getTimezone()));
    }

    private static ScheduleBuilder buildOnceSchedule(ScheduleJobInstanceDTO instance) {
        return SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(1).withRepeatCount(0);
    }

    private static /* synthetic */ QuartzUtil[] $values() {
        return new QuartzUtil[0];
    }

    static {
        $VALUES = QuartzUtil.$values();
    }
}

