/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.nio;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class FileUtil
extends Enum<FileUtil> {
    private static boolean SUPPORT_POSIX;
    public static final FileAttribute<Set<PosixFilePermission>> ATTRIBUTES;
    private static final /* synthetic */ FileUtil[] $VALUES;

    public static FileUtil[] values() {
        return (FileUtil[])$VALUES.clone();
    }

    public static FileUtil valueOf(String name) {
        return Enum.valueOf(FileUtil.class, name);
    }

    public static boolean supportPosix() {
        return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    }

    public static Path createDir() throws IOException {
        if (SUPPORT_POSIX) {
            return Files.createTempDirectory(null, ATTRIBUTES);
        }
        return Files.createTempDirectory(null, new FileAttribute[0]);
    }

    public static Path getBaseTempDir() throws IOException {
        try {
            String path = System.getProperty("java.io.tmpdir");
            return Paths.get(path, new String[0]);
        }
        catch (Exception e) {
            return FileUtil.createDir();
        }
    }

    public static Path createTempDir(String dirName) throws IOException {
        return FileUtil.createDir(FileUtil.getBaseTempDir(), dirName);
    }

    public static Path createTempFile(String fileName) throws IOException {
        return FileUtil.createTempFile(FileUtil.getBaseTempDir(), fileName);
    }

    public static Path createTempFile(Path tempDir, String fileName) throws IOException {
        return FileUtil.createTempFile(tempDir, fileName, null);
    }

    public static Path createTempFile(Path tempDir, String prefix, String suffix) throws IOException {
        if (SUPPORT_POSIX) {
            return Files.createTempFile(tempDir, prefix, suffix, ATTRIBUTES);
        }
        return Files.createTempFile(tempDir, prefix, suffix, new FileAttribute[0]);
    }

    public static Path createDir(Path parentDir, String dirName) throws IOException {
        Path dir = Paths.get(parentDir.toString(), dirName);
        if (Files.notExists(dir, new LinkOption[0])) {
            if (SUPPORT_POSIX) {
                return Files.createDirectories(dir, ATTRIBUTES);
            }
            return Files.createDirectories(dir, new FileAttribute[0]);
        }
        return dir;
    }

    public static Path createDir(Path dir) throws IOException {
        if (Files.notExists(dir, new LinkOption[0])) {
            if (SUPPORT_POSIX) {
                return Files.createDirectories(dir, ATTRIBUTES);
            }
            return Files.createDirectories(dir, new FileAttribute[0]);
        }
        return dir;
    }

    public static Path createFile(Path parent, String fileName) throws IOException {
        Path filePath = Paths.get(parent.toString(), fileName);
        return FileUtil.createFile(filePath);
    }

    public static Path createFile(Path filePath) throws IOException {
        Files.deleteIfExists(filePath);
        FileUtil.createDir(filePath.getParent());
        if (SUPPORT_POSIX) {
            return Files.createFile(filePath, ATTRIBUTES);
        }
        return Files.createFile(filePath, new FileAttribute[0]);
    }

    public static void deleteFile(Path file) throws IOException {
        Files.deleteIfExists(file);
    }

    public static void deleteDir(Path dir) throws IOException {
        if (Files.exists(dir, new LinkOption[0])) {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.deleteIfExists(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.deleteIfExists(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
            Files.deleteIfExists(dir);
        }
    }

    public static OutputStream getOutputStream(File file) throws IOException {
        if (!file.exists()) {
            FileUtil.createFile(file.toPath());
        }
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    public static OutputStream getOutputStream(Path path) throws IOException {
        return FileUtil.getOutputStream(path.toFile());
    }

    public static Writer getWriter(File file) throws IOException {
        if (!file.exists()) {
            FileUtil.createFile(file.toPath());
        }
        return new FileWriter(file);
    }

    public static Writer getWriter(Path path) throws IOException {
        return FileUtil.getWriter(path.toFile());
    }

    public static InputStream getInputStream(File file) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(file));
    }

    public static InputStream getInputStream(Path filePath) throws FileNotFoundException {
        return FileUtil.getInputStream(filePath.toFile());
    }

    public static List<Path> listFiles(Path path) throws IOException {
        if (path == null) {
            return null;
        }
        return Files.list(path).collect(Collectors.toList());
    }

    public static List<Path> listFilesRecursively(Path path, Function<Path, Boolean> filter) throws IOException {
        List<Path> paths = new ArrayList<Path>();
        if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
            FilterFileVisitor filterFileVisitor = new FilterFileVisitor(filter);
            Files.walkFileTree(path, filterFileVisitor);
            paths = filterFileVisitor.getPaths();
        }
        return paths;
    }

    private static /* synthetic */ FileUtil[] $values() {
        return new FileUtil[0];
    }

    static {
        $VALUES = FileUtil.$values();
        SUPPORT_POSIX = FileUtil.supportPosix();
        ATTRIBUTES = PosixFilePermissions.asFileAttribute(new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_EXECUTE)));
    }

    private static class FilterFileVisitor
    extends SimpleFileVisitor<Path> {
        private final List<Path> paths = new ArrayList<Path>();
        private final Function<Path, Boolean> filter;

        public FilterFileVisitor(Function<Path, Boolean> filter) {
            this.filter = filter;
        }

        public List<Path> getPaths() {
            return this.paths;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (this.filter.apply(dir).booleanValue()) {
                this.paths.add(dir);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (this.filter.apply(file).booleanValue()) {
                this.paths.add(file);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

