/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.reflection.instructions;

import cn.sliew.carp.framework.common.reflection.JobDetailsBuilder;
import cn.sliew.carp.framework.common.reflection.instructions.AAStoreInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.ALoadOperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.ANewArrayOperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.AStoreInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.AbstractJVMInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.BAStoreOperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.CheckCastOperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.DLoadOperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.DStoreInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.DupOperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.FLoadOperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.FStoreInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.GetFieldInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.GetStaticInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.I2BOperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.I2COperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.I2DOperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.I2FOperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.I2LOperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.I2SOperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.IConst0OperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.IConst1OperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.IConst2OperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.IConst3OperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.IConst4OperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.IConst5OperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.ILoadOperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.IStoreInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.InvokeDynamicInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.InvokeInterfaceInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.InvokeSpecialInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.InvokeStaticInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.InvokeVirtualInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.LConst0OperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.LConst1OperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.LLoadOperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.LStoreInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.LdcInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.NewOperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.PopOperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.ReturnOperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.SingleIntOperandInstruction;
import cn.sliew.carp.framework.common.reflection.instructions.SwapOperandInstruction;
import cn.sliew.carp.framework.common.util.reflection.ReflectionUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class AllJVMInstructions {
    private static final Map<Integer, Function<JobDetailsBuilder, AbstractJVMInstruction>> instructions = new HashMap<Integer, Function<JobDetailsBuilder, AbstractJVMInstruction>>();
    private static final Map<Integer, String> unsupportedInstructions = new HashMap<Integer, String>();
    private static final Map<Integer, String> kotlinUnsupportedInstructions = new HashMap<Integer, String>();

    private AllJVMInstructions() {
    }

    public static <T extends AbstractJVMInstruction> T get(int opcode, JobDetailsBuilder jobDetailsBuilder) {
        Function<JobDetailsBuilder, AbstractJVMInstruction> instructionBuilder = instructions.get(opcode);
        if (instructionBuilder == null) {
            if (unsupportedInstructions.containsKey(opcode)) {
                throw new IllegalArgumentException("Unsupported lambda", new UnsupportedOperationException(unsupportedInstructions.get(opcode)));
            }
            if (ReflectionUtils.classExists("kotlin.KotlinVersion") && kotlinUnsupportedInstructions.containsKey(opcode)) {
                throw new IllegalArgumentException("Unsupported lambda", new UnsupportedOperationException(kotlinUnsupportedInstructions.get(opcode)));
            }
            throw new IllegalArgumentException("Instruction " + opcode + " not found");
        }
        return (T)((AbstractJVMInstruction)ReflectionUtils.cast(instructionBuilder.apply(jobDetailsBuilder)));
    }

    static {
        instructions.put(83, AAStoreInstruction::new);
        instructions.put(25, ALoadOperandInstruction::new);
        instructions.put(189, ANewArrayOperandInstruction::new);
        instructions.put(58, AStoreInstruction::new);
        instructions.put(16, SingleIntOperandInstruction::new);
        instructions.put(192, CheckCastOperandInstruction::new);
        instructions.put(24, DLoadOperandInstruction::new);
        instructions.put(23, FLoadOperandInstruction::new);
        instructions.put(145, I2BOperandInstruction::new);
        instructions.put(146, I2COperandInstruction::new);
        instructions.put(135, I2DOperandInstruction::new);
        instructions.put(134, I2FOperandInstruction::new);
        instructions.put(133, I2LOperandInstruction::new);
        instructions.put(147, I2SOperandInstruction::new);
        instructions.put(3, IConst0OperandInstruction::new);
        instructions.put(4, IConst1OperandInstruction::new);
        instructions.put(5, IConst2OperandInstruction::new);
        instructions.put(6, IConst3OperandInstruction::new);
        instructions.put(7, IConst4OperandInstruction::new);
        instructions.put(8, IConst5OperandInstruction::new);
        instructions.put(186, InvokeDynamicInstruction::new);
        instructions.put(185, InvokeInterfaceInstruction::new);
        instructions.put(183, InvokeSpecialInstruction::new);
        instructions.put(184, InvokeStaticInstruction::new);
        instructions.put(182, InvokeVirtualInstruction::new);
        instructions.put(54, IStoreInstruction::new);
        instructions.put(55, LStoreInstruction::new);
        instructions.put(57, DStoreInstruction::new);
        instructions.put(56, FStoreInstruction::new);
        instructions.put(89, DupOperandInstruction::new);
        instructions.put(95, SwapOperandInstruction::new);
        instructions.put(21, ILoadOperandInstruction::new);
        instructions.put(9, LConst0OperandInstruction::new);
        instructions.put(10, LConst1OperandInstruction::new);
        instructions.put(18, LdcInstruction::new);
        instructions.put(22, LLoadOperandInstruction::new);
        instructions.put(187, NewOperandInstruction::new);
        instructions.put(87, PopOperandInstruction::new);
        instructions.put(180, GetFieldInstruction::new);
        instructions.put(178, GetStaticInstruction::new);
        instructions.put(177, ReturnOperandInstruction::new);
        instructions.put(17, SingleIntOperandInstruction::new);
        instructions.put(84, BAStoreOperandInstruction::new);
        String mathematicalPerformanceSuffix = " - for performance reasons it is better to do the calculation outside of the job lambda";
        Arrays.asList(96, 97, 98, 99).forEach(instr -> unsupportedInstructions.put((Integer)instr, "You are summing two numbers while enqueueing/scheduling jobs" + mathematicalPerformanceSuffix));
        Arrays.asList(100, 101, 102, 103).forEach(instr -> unsupportedInstructions.put((Integer)instr, "You are subtracting two numbers while enqueueing/scheduling jobs" + mathematicalPerformanceSuffix));
        Arrays.asList(104, 105, 106, 107).forEach(instr -> unsupportedInstructions.put((Integer)instr, "You are multiplying two numbers while enqueueing/scheduling jobs" + mathematicalPerformanceSuffix));
        Arrays.asList(108, 109, 110, 111).forEach(instr -> unsupportedInstructions.put((Integer)instr, "You are dividing two numbers while enqueueing/scheduling jobs" + mathematicalPerformanceSuffix));
        Arrays.asList(112, 113, 114, 115).forEach(instr -> unsupportedInstructions.put((Integer)instr, "You are calculating the remainder (%) for two numbers while enqueueing/scheduling jobs" + mathematicalPerformanceSuffix));
        kotlinUnsupportedInstructions.put(1, "You are (probably) using Kotlin default parameter values which is not supported by JobRunr.");
    }
}

