/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.reflection.instructions;

import cn.sliew.carp.framework.common.reflection.JobDetailsBuilder;
import cn.sliew.carp.framework.common.reflection.JobDetailsGeneratorUtils;
import cn.sliew.carp.framework.common.reflection.instructions.VisitMethodInstruction;
import cn.sliew.carp.framework.common.util.reflection.ReflectionUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;

public class InvokeSpecialInstruction
extends VisitMethodInstruction {
    public InvokeSpecialInstruction(JobDetailsBuilder jobDetailsBuilder) {
        super(jobDetailsBuilder);
    }

    @Override
    public Object invokeInstruction() {
        if ("<init>".equals(this.name)) {
            List<Object> parameters;
            Class<?>[] paramTypes;
            String className = JobDetailsGeneratorUtils.toFQClassName(this.owner);
            Object objectViaConstructor = JobDetailsGeneratorUtils.createObjectViaConstructor(className, paramTypes = JobDetailsGeneratorUtils.findParamTypesFromDescriptorAsArray(this.descriptor), (parameters = this.getParametersUsingParamTypes(paramTypes)).toArray());
            if (this.isKotlinMethodReference(objectViaConstructor)) {
                this.jobDetailsBuilder.setClassName(((Class)ReflectionUtils.getValueFromFieldOrProperty(objectViaConstructor, "owner")).getName());
                this.jobDetailsBuilder.setMethodName((String)ReflectionUtils.getValueFromFieldOrProperty(objectViaConstructor, "name"));
            }
            return objectViaConstructor;
        }
        String className = JobDetailsGeneratorUtils.toFQClassName(this.owner);
        Class objectClass = ReflectionUtils.toClass(className);
        Method method = ReflectionUtils.getMethod(objectClass, this.name, JobDetailsGeneratorUtils.findParamTypesFromDescriptorAsArray(this.descriptor));
        if (Modifier.isPrivate(method.getModifiers())) {
            throw new RuntimeException(String.format("JobRunr cannot access member \"%s\" of class %s with modifiers \"private\". Please make the method \"public\".", this.name, className));
        }
        throw new IllegalStateException("Unknown INVOKESPECIAL instruction: " + className + "." + this.name);
    }

    private boolean isKotlinMethodReference(Object objectViaConstructor) {
        return Arrays.stream(objectViaConstructor.getClass().getInterfaces()).map(Class::getName).anyMatch(name -> name.startsWith("kotlin.jvm.functions.Function"));
    }
}

