/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.util.reflection.autobox;

import cn.sliew.carp.framework.common.util.reflection.ReflectionUtils;
import cn.sliew.carp.framework.common.util.reflection.autobox.TypeAutoboxer;
import java.math.BigDecimal;

public class BooleanTypeAutoboxer
implements TypeAutoboxer<Boolean> {
    @Override
    public boolean supports(Class<?> type) {
        return Boolean.class.equals(type) || Boolean.TYPE.equals(type);
    }

    @Override
    public Boolean autobox(Object value, Class<Boolean> type) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof BigDecimal) {
            return (Boolean)ReflectionUtils.cast(!BigDecimal.ZERO.equals(value));
        }
        if (value instanceof Integer) {
            return (Boolean)ReflectionUtils.cast((Integer)value != 0);
        }
        throw new UnsupportedOperationException(String.format("Cannot autobox %s of type %s to %s", value, value.getClass().getName(), Boolean.class.getName()));
    }
}

