/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.util.reflection.autobox;

import cn.sliew.carp.framework.common.util.reflection.ReflectionUtils;
import cn.sliew.carp.framework.common.util.reflection.autobox.TypeAutoboxer;
import java.math.BigDecimal;

public class LongTypeAutoboxer
implements TypeAutoboxer<Long> {
    @Override
    public boolean supports(Class<?> type) {
        return Long.TYPE.equals(type) || Long.class.equals(type);
    }

    @Override
    public Long autobox(Object value, Class<Long> type) {
        if (value instanceof Long) {
            return (Long)ReflectionUtils.cast(value);
        }
        if (value instanceof BigDecimal) {
            return (Long)ReflectionUtils.cast(((BigDecimal)value).longValue());
        }
        if (value instanceof Integer) {
            return (Long)ReflectionUtils.cast((Integer)value);
        }
        if (value instanceof String) {
            return (Long)ReflectionUtils.cast(Long.valueOf((String)value));
        }
        throw new UnsupportedOperationException(String.format("Cannot autobox %s of type %s to %s", value, value.getClass().getName(), Long.class.getName()));
    }
}

