/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.plugin.plugin;

import cn.hutool.extra.spring.SpringUtil;
import cn.sliew.carp.framework.common.dict.common.YesOrNo;
import cn.sliew.carp.framework.common.nio.FileUtil;
import cn.sliew.carp.module.plugin.service.PluginService;
import cn.sliew.carp.module.plugin.service.dto.CarpPluginDTO;
import cn.sliew.carp.module.plugin.service.param.CarpPluginListParam;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.pf4j.PluginRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomPluginRepository
implements PluginRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomPluginRepository.class);
    protected FileFilter filter;

    public CustomPluginRepository() {
        this(null);
    }

    public CustomPluginRepository(FileFilter filter) {
        this.filter = filter;
    }

    public List<Path> getPluginPaths() {
        PluginService pluginService = (PluginService)SpringUtil.getBean(PluginService.class);
        CarpPluginListParam listParam = new CarpPluginListParam();
        listParam.setStatus(YesOrNo.YES.getValue());
        List<CarpPluginDTO> carpPluginDTOS = pluginService.listAll(listParam);
        ArrayList<Path> paths = new ArrayList<Path>();
        for (CarpPluginDTO dto : carpPluginDTOS) {
            try {
                Path path = pluginService.internalDownloadPlugin(dto);
                if (this.filter != null && !this.filter.accept(path.toFile())) continue;
                paths.add(path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return paths;
    }

    public boolean deletePluginPath(Path path) {
        try {
            FileUtil.deleteFile((Path)path);
            return true;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

