/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.ui;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.ui.AbstractSwaggerResourceResolver;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolverChain;

public class SwaggerResourceResolver
extends AbstractSwaggerResourceResolver
implements ResourceResolver {
    public SwaggerResourceResolver(SwaggerUiConfigProperties swaggerUiConfigProperties) {
        super(swaggerUiConfigProperties);
    }

    public Resource resolveResource(HttpServletRequest request, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        String webJarResourcePath;
        Resource resolved = chain.resolveResource(request, requestPath, locations);
        if (resolved == null && (webJarResourcePath = this.findWebJarResourcePath(requestPath)) != null) {
            return chain.resolveResource(request, webJarResourcePath, locations);
        }
        return resolved;
    }

    public String resolveUrlPath(String resourcePath, List<? extends Resource> locations, ResourceResolverChain chain) {
        String webJarResourcePath;
        String path = chain.resolveUrlPath(resourcePath, locations);
        if (path == null && (webJarResourcePath = this.findWebJarResourcePath(resourcePath)) != null) {
            return chain.resolveUrlPath(webJarResourcePath, locations);
        }
        return path;
    }
}

