/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.scheduler.service.impl;

import cn.sliew.carp.framework.common.model.PageResult;
import cn.sliew.carp.framework.mybatis.entity.BaseDO;
import cn.sliew.carp.module.scheduler.repository.entity.ScheduleJobInstance;
import cn.sliew.carp.module.scheduler.repository.entity.ScheduleJobInstanceVO;
import cn.sliew.carp.module.scheduler.repository.mapper.ScheduleJobInstanceMapper;
import cn.sliew.carp.module.scheduler.service.ScheduleJobInstanceService;
import cn.sliew.carp.module.scheduler.service.convert.ScheduleJobInstanceConvert;
import cn.sliew.carp.module.scheduler.service.dto.ScheduleJobInstanceDTO;
import cn.sliew.carp.module.scheduler.service.param.ScheduleJobInstanceAddParam;
import cn.sliew.carp.module.scheduler.service.param.ScheduleJobInstanceListParam;
import cn.sliew.carp.module.scheduler.service.param.ScheduleJobInstancePageParam;
import cn.sliew.carp.module.scheduler.service.param.ScheduleJobInstanceUpdateParam;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class ScheduleJobInstanceServiceImpl
extends ServiceImpl<ScheduleJobInstanceMapper, ScheduleJobInstance>
implements ScheduleJobInstanceService {
    @Override
    public PageResult<ScheduleJobInstanceDTO> list(ScheduleJobInstancePageParam param) {
        Page page = new Page(param.getCurrent().longValue(), param.getPageSize().longValue());
        LambdaQueryWrapper queryChainWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ScheduleJobInstance.class).eq(ScheduleJobInstance::getJobConfigId, (Object)param.getJobConfigId())).like(StringUtils.hasText((String)param.getName()), ScheduleJobInstance::getName, (Object)param.getName())).eq(StringUtils.hasText((String)param.getStatus()), ScheduleJobInstance::getStatus, (Object)param.getStatus())).orderByAsc(BaseDO::getId);
        Page scheduleJobInstancePage = (Page)this.page((IPage)page, (Wrapper)queryChainWrapper);
        PageResult pageResult = new PageResult(Long.valueOf(scheduleJobInstancePage.getCurrent()), Long.valueOf(scheduleJobInstancePage.getSize()), Long.valueOf(scheduleJobInstancePage.getTotal()));
        pageResult.setRecords(ScheduleJobInstanceConvert.INSTANCE.toDto(scheduleJobInstancePage.getRecords()));
        return pageResult;
    }

    @Override
    public List<ScheduleJobInstanceDTO> listAll(ScheduleJobInstanceListParam param) {
        LambdaQueryWrapper queryChainWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ScheduleJobInstance.class).eq(ScheduleJobInstance::getJobConfigId, (Object)param.getJobConfigId())).eq(StringUtils.hasText((String)param.getStatus()), ScheduleJobInstance::getStatus, (Object)param.getStatus())).orderByAsc(BaseDO::getId);
        List list = this.list((Wrapper)queryChainWrapper);
        return ScheduleJobInstanceConvert.INSTANCE.toDto(list);
    }

    @Override
    public ScheduleJobInstanceDTO get(Long id) {
        ScheduleJobInstanceVO entity = ((ScheduleJobInstanceMapper)this.baseMapper).get(id);
        Preconditions.checkNotNull((Object)((Object)entity), (Object)("schedule job instance not exists for id: " + id));
        return ScheduleJobInstanceConvert.INSTANCE.toDto(entity);
    }

    @Override
    public boolean add(ScheduleJobInstanceAddParam param) {
        ScheduleJobInstance entity = new ScheduleJobInstance();
        BeanUtils.copyProperties((Object)param, (Object)((Object)entity));
        return this.save((Object)entity);
    }

    @Override
    public boolean update(ScheduleJobInstanceUpdateParam param) {
        ScheduleJobInstance entity = new ScheduleJobInstance();
        BeanUtils.copyProperties((Object)param, (Object)((Object)entity));
        return this.updateById((Object)entity);
    }

    @Override
    public boolean updateStatus(Long id, String status) {
        ScheduleJobInstance entity = new ScheduleJobInstance();
        entity.setId(id);
        entity.setStatus(status);
        return this.updateById((Object)entity);
    }

    @Override
    public boolean delete(Long id) {
        return this.removeById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, transactionManager="carpTransactionManager")
    public boolean deleteBatch(Collection<Long> ids) {
        return this.removeBatchByIds(ids);
    }
}

