/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.workflow.api.service.impl;

import cn.sliew.carp.framework.dag.service.DagConfigComplexService;
import cn.sliew.carp.framework.dag.service.DagConfigStepService;
import cn.sliew.carp.framework.dag.service.DagInstanceComplexService;
import cn.sliew.carp.framework.dag.service.dto.DagConfigComplexDTO;
import cn.sliew.carp.framework.dag.service.dto.DagConfigStepDTO;
import cn.sliew.carp.framework.dag.service.dto.DagInstanceComplexDTO;
import cn.sliew.carp.framework.dag.service.param.DagConfigSimpleAddParam;
import cn.sliew.carp.framework.dag.x6.graph.DagGraphVO;
import cn.sliew.carp.module.workflow.api.service.WorkflowDagService;
import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowDagServiceImpl
implements WorkflowDagService {
    @Autowired
    private DagConfigComplexService dagConfigComplexService;
    @Autowired
    private DagConfigStepService dagConfigStepService;
    @Autowired
    private DagInstanceComplexService dagInstanceComplexService;

    @Override
    public Long initialize(String name, JsonNode inputParams, String remark) {
        DagConfigSimpleAddParam param = new DagConfigSimpleAddParam();
        param.setType("WorkFlow");
        param.setName(name);
        param.setInputOptions(inputParams);
        param.setRemark(remark);
        return this.dagConfigComplexService.insert(param);
    }

    @Override
    public void destroy(Long dagId) {
        this.dagConfigComplexService.delete(dagId);
    }

    @Override
    public DagConfigComplexDTO getDag(Long dagId) {
        return this.dagConfigComplexService.selectOne(dagId);
    }

    @Override
    public DagConfigStepDTO getStep(Long stepId) {
        return this.dagConfigStepService.get(stepId);
    }

    @Override
    public void update(Long dagId, DagGraphVO graph) {
        this.dagConfigComplexService.replace(dagId, graph);
    }

    @Override
    public DagInstanceComplexDTO getDagInstance(Long dagInstanceId) {
        return this.dagInstanceComplexService.selectOne(dagInstanceId);
    }
}

