/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.dag.algorithm;

import cn.sliew.carp.framework.dag.algorithm.DagUtil;
import cn.sliew.carp.framework.dag.algorithm.DefaultDagEdge;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.shortestpath.AllDirectedPaths;
import org.jgrapht.graph.builder.GraphTypeBuilder;
import org.jgrapht.traverse.TopologicalOrderIterator;

public class DAG<N> {
    private Graph<N, DefaultDagEdge<N>> jgrapht = GraphTypeBuilder.directed().allowingSelfLoops(false).weighted(false).buildGraph();

    public void addNode(N node) {
        this.jgrapht.addVertex(node);
    }

    public void addEdge(N source, N target) {
        this.jgrapht.addEdge(source, target, new DefaultDagEdge<N>(source, target));
    }

    public Set<N> nodes() {
        return this.jgrapht.vertexSet();
    }

    public Set<DefaultDagEdge<N>> edges() {
        return this.jgrapht.edgeSet();
    }

    public DefaultDagEdge<N> getEdge(N source, N target) {
        return (DefaultDagEdge)this.jgrapht.getEdge(source, target);
    }

    public void removeEdge(N source, N target) {
        this.jgrapht.removeEdge(source, target);
    }

    public Integer inDegree(N node) {
        return this.jgrapht.inDegreeOf(node);
    }

    public Set<N> inDegreeOf(N node) {
        return this.jgrapht.incomingEdgesOf(node).stream().map(DefaultDagEdge::getTarget).collect(Collectors.toSet());
    }

    public Integer outDegree(N node) {
        return this.jgrapht.outDegreeOf(node);
    }

    public Set<N> outDegreeOf(N node) {
        return this.jgrapht.outgoingEdgesOf(node).stream().map(DefaultDagEdge::getTarget).collect(Collectors.toSet());
    }

    public Set<N> getSources() {
        return this.jgrapht.vertexSet().stream().filter(node -> this.jgrapht.inDegreeOf(node) == 0).collect(Collectors.toSet());
    }

    public Set<N> getSinks() {
        return this.jgrapht.vertexSet().stream().filter(node -> this.jgrapht.outDegreeOf(node) == 0).collect(Collectors.toSet());
    }

    public Integer getMaxDepth() {
        AllDirectedPaths paths = new AllDirectedPaths(this.jgrapht);
        return paths.getAllPaths(this.getSources(), this.getSinks(), true, null).stream().map(GraphPath::getLength).sorted().findFirst().get();
    }

    public List<N> topologySort() {
        ArrayList queue = Lists.newArrayList();
        this.topologyTraversal(node -> queue.add(node));
        return queue;
    }

    public void topologyTraversal(Consumer<N> consumer) {
        TopologicalOrderIterator iterator = new TopologicalOrderIterator(this.jgrapht);
        while (iterator.hasNext()) {
            consumer.accept(iterator.next());
        }
    }

    public DAG<N> copy() {
        DAG copy = new DAG();
        this.nodes().forEach(copy::addNode);
        this.edges().forEach(edge -> copy.addEdge(edge.getSource(), edge.getTarget()));
        return copy;
    }

    public static void main(String[] args) {
        DAG<String> dag = new DAG<String>();
        dag.addNode("A");
        dag.addNode("B");
        dag.addNode("C");
        dag.addNode("D");
        dag.addNode("E");
        dag.addNode("F");
        dag.addNode("G");
        dag.addNode("H");
        dag.addNode("I");
        dag.addNode("J");
        dag.addNode("K");
        dag.addEdge("A", "B");
        dag.addEdge("B", "C");
        dag.addEdge("B", "D");
        dag.addEdge("B", "E");
        dag.addEdge("A", "F");
        dag.addEdge("A", "K");
        dag.addEdge("C", "G");
        dag.addEdge("D", "G");
        dag.addEdge("E", "G");
        dag.addEdge("F", "H");
        dag.addEdge("G", "H");
        dag.addEdge("H", "I");
        dag.addEdge("H", "J");
        System.out.println(dag.topologySort());
        ArrayList queue = Lists.newArrayList();
        DagUtil.execute(dag, nodes -> queue.add(nodes));
        System.out.println(queue);
    }
}

