/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.dag.algorithm;

import cn.sliew.carp.framework.dag.algorithm.DAG;
import cn.sliew.carp.framework.dag.algorithm.DefaultDagEdge;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public final class DagUtil
extends Enum<DagUtil> {
    private static final /* synthetic */ DagUtil[] $VALUES;

    public static DagUtil[] values() {
        return (DagUtil[])$VALUES.clone();
    }

    public static DagUtil valueOf(String name) {
        return Enum.valueOf(DagUtil.class, name);
    }

    public static <N> void execute(DAG<N> dag, Consumer<Set<N>> consumer) {
        DagUtil.execute(dag, (dag1, node) -> true, (dag1, edge) -> true, consumer);
    }

    public static <N> void execute(DAG<N> dag, BiPredicate<DAG<N>, N> nodeValidator, BiPredicate<DAG<N>, DefaultDagEdge<N>> edgeValidator, Consumer<Set<N>> consumer) {
        Set<N> sources = dag.getSources();
        DAG<N> state = dag.copy();
        DagUtil.doExecute(dag, state, sources, nodeValidator, edgeValidator, consumer);
    }

    private static <N> void doExecute(DAG<N> dag, DAG<N> state, Set<N> set, BiPredicate<DAG<N>, N> nodeValidator, BiPredicate<DAG<N>, DefaultDagEdge<N>> edgeValidator, Consumer<Set<N>> consumer) {
        if (CollectionUtils.isEmpty(set)) {
            return;
        }
        Set checkedSet = set.stream().filter(node -> nodeValidator.test(dag, node)).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(checkedSet)) {
            consumer.accept(checkedSet);
        }
        LinkedHashSet nextSet = Sets.newLinkedHashSet();
        set.forEach(node -> dag.outDegreeOf(node).forEach(outDegreeNode -> {
            DefaultDagEdge<Object> edge = dag.getEdge(node, outDegreeNode);
            if (edgeValidator.test(dag, edge)) {
                state.removeEdge(node, outDegreeNode);
            }
            if (state.inDegree(outDegreeNode) == 0) {
                nextSet.add(outDegreeNode);
            }
        }));
        if (CollectionUtils.isNotEmpty((Collection)nextSet)) {
            DagUtil.doExecute(dag, state, nextSet, nodeValidator, edgeValidator, consumer);
        }
    }

    private static /* synthetic */ DagUtil[] $values() {
        return new DagUtil[0];
    }

    static {
        $VALUES = DagUtil.$values();
    }
}

