/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.dag.service.convert;

import cn.sliew.carp.framework.common.convert.BaseConvert;
import cn.sliew.carp.framework.dag.repository.entity.DagConfig;
import cn.sliew.carp.framework.dag.service.dto.DagConfigDTO;
import cn.sliew.milky.common.util.JacksonUtil;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE)
public interface DagConfigConvert
extends BaseConvert<DagConfig, DagConfigDTO> {
    public static final DagConfigConvert INSTANCE = (DagConfigConvert)Mappers.getMapper(DagConfigConvert.class);

    default public DagConfig toDo(DagConfigDTO dto) {
        DagConfig entity = new DagConfig();
        BeanUtils.copyProperties((Object)((Object)dto), (Object)((Object)entity));
        if (dto.getDagMeta() != null) {
            entity.setDagMeta(dto.getDagMeta().toString());
        }
        if (dto.getDagAttrs() != null) {
            entity.setDagAttrs(dto.getDagAttrs().toString());
        }
        if (dto.getIntputOptions() != null) {
            entity.setIntputOptions(dto.getIntputOptions().toString());
        }
        if (dto.getOutputOptions() != null) {
            entity.setOutputOptions(dto.getOutputOptions().toString());
        }
        return entity;
    }

    default public DagConfigDTO toDto(DagConfig entity) {
        DagConfigDTO dto = new DagConfigDTO();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)dto));
        if (StringUtils.hasText((String)entity.getDagMeta())) {
            dto.setDagMeta(JacksonUtil.toJsonNode((String)entity.getDagMeta()));
        }
        if (StringUtils.hasText((String)entity.getDagAttrs())) {
            dto.setDagAttrs(JacksonUtil.toJsonNode((String)entity.getDagAttrs()));
        }
        if (StringUtils.hasText((String)entity.getIntputOptions())) {
            dto.setIntputOptions(JacksonUtil.toJsonNode((String)entity.getIntputOptions()));
        }
        if (StringUtils.hasText((String)entity.getOutputOptions())) {
            dto.setOutputOptions(JacksonUtil.toJsonNode((String)entity.getOutputOptions()));
        }
        return dto;
    }
}

