/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.dag.service.impl;

import cn.sliew.carp.framework.dag.repository.entity.DagConfigLink;
import cn.sliew.carp.framework.dag.repository.mapper.DagConfigLinkMapper;
import cn.sliew.carp.framework.dag.service.DagConfigLinkService;
import cn.sliew.carp.framework.dag.service.convert.DagConfigLinkConvert;
import cn.sliew.carp.framework.dag.service.dto.DagConfigLinkDTO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DagConfigLinkServiceImpl
extends ServiceImpl<DagConfigLinkMapper, DagConfigLink>
implements DagConfigLinkService {
    @Override
    public List<DagConfigLinkDTO> listLinks(Long dagId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(DagConfigLink.class).eq(DagConfigLink::getDagId, (Object)dagId);
        List dagConfigLinks = this.list((Wrapper)queryWrapper);
        return DagConfigLinkConvert.INSTANCE.toDto(dagConfigLinks);
    }

    @Override
    public boolean add(DagConfigLinkDTO linkDTO) {
        DagConfigLink record = DagConfigLinkConvert.INSTANCE.toDo(linkDTO);
        return this.save((Object)record);
    }

    @Override
    public boolean update(DagConfigLinkDTO linkDTO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(DagConfigLink.class).eq(DagConfigLink::getDagId, (Object)linkDTO.getDagId())).eq(DagConfigLink::getLinkId, (Object)linkDTO.getLinkId());
        DagConfigLink record = DagConfigLinkConvert.INSTANCE.toDo(linkDTO);
        return this.update((Object)record, (Wrapper)updateWrapper);
    }

    @Override
    public void upsert(DagConfigLinkDTO linkDTO) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DagConfigLink.class).eq(DagConfigLink::getDagId, (Object)linkDTO.getDagId())).eq(DagConfigLink::getLinkId, (Object)linkDTO.getLinkId());
        if (this.exists((Wrapper)queryWrapper)) {
            this.update(linkDTO);
        } else {
            this.add(linkDTO);
        }
    }

    @Override
    public boolean deleteByDag(Long dagId) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)Wrappers.lambdaUpdate(DagConfigLink.class).eq(DagConfigLink::getDagId, (Object)dagId);
        return this.remove((Wrapper)updateWrapper);
    }

    @Override
    public boolean deleteBatchByDag(List<Long> dagIds) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)Wrappers.lambdaUpdate(DagConfigLink.class).in(DagConfigLink::getDagId, dagIds);
        return this.remove((Wrapper)updateWrapper);
    }

    @Override
    public boolean deleteSurplusLinks(Long dagId, List<String> linkIds) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(DagConfigLink.class).eq(DagConfigLink::getDagId, (Object)dagId)).notIn(!CollectionUtils.isEmpty(linkIds), DagConfigLink::getLinkId, linkIds);
        return this.remove((Wrapper)updateWrapper);
    }

    @Override
    public int clone(Long sourceDagId, Long targetDagId) {
        List<DagConfigLinkDTO> sourceLinks = this.listLinks(sourceDagId);
        sourceLinks.stream().forEach(linkDTO -> {
            linkDTO.setDagId(targetDagId);
            linkDTO.setId(null);
            linkDTO.setCreator(null);
            linkDTO.setCreateTime(null);
            linkDTO.setEditor(null);
            linkDTO.setUpdateTime(null);
            this.add((DagConfigLinkDTO)((Object)linkDTO));
        });
        return sourceLinks.size();
    }
}

