/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.dag.service.impl;

import cn.sliew.carp.framework.dag.repository.entity.DagConfigStep;
import cn.sliew.carp.framework.dag.repository.mapper.DagConfigStepMapper;
import cn.sliew.carp.framework.dag.service.DagConfigStepService;
import cn.sliew.carp.framework.dag.service.convert.DagConfigStepConvert;
import cn.sliew.carp.framework.dag.service.dto.DagConfigStepDTO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DagConfigStepServiceImpl
extends ServiceImpl<DagConfigStepMapper, DagConfigStep>
implements DagConfigStepService {
    @Override
    public List<DagConfigStepDTO> listSteps(Long dagId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(DagConfigStep.class).eq(DagConfigStep::getDagId, (Object)dagId);
        List dagConfigSteps = this.list((Wrapper)queryWrapper);
        return DagConfigStepConvert.INSTANCE.toDto(dagConfigSteps);
    }

    @Override
    public DagConfigStepDTO get(Long id) {
        DagConfigStep entity = (DagConfigStep)((Object)this.getOptById(id).orElseThrow(() -> new IllegalArgumentException("dag config step not exists for id: " + id)));
        return DagConfigStepConvert.INSTANCE.toDto(entity);
    }

    @Override
    public boolean add(DagConfigStepDTO stepDTO) {
        DagConfigStep record = DagConfigStepConvert.INSTANCE.toDo(stepDTO);
        return this.save((Object)record);
    }

    @Override
    public boolean update(DagConfigStepDTO stepDTO) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(DagConfigStep.class).eq(DagConfigStep::getDagId, (Object)stepDTO.getDagId())).eq(DagConfigStep::getStepId, (Object)stepDTO.getStepId());
        DagConfigStep record = DagConfigStepConvert.INSTANCE.toDo(stepDTO);
        return this.update((Object)record, (Wrapper)updateWrapper);
    }

    @Override
    public void upsert(DagConfigStepDTO stepDTO) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DagConfigStep.class).eq(DagConfigStep::getDagId, (Object)stepDTO.getDagId())).eq(DagConfigStep::getStepId, (Object)stepDTO.getStepId());
        if (this.exists((Wrapper)queryWrapper)) {
            this.update(stepDTO);
        } else {
            this.add(stepDTO);
        }
    }

    @Override
    public boolean deleteByDag(Long dagId) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)Wrappers.lambdaUpdate(DagConfigStep.class).eq(DagConfigStep::getDagId, (Object)dagId);
        return this.remove((Wrapper)updateWrapper);
    }

    @Override
    public boolean deleteByDag(List<Long> dagIds) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)Wrappers.lambdaUpdate(DagConfigStep.class).in(DagConfigStep::getDagId, dagIds);
        return this.remove((Wrapper)updateWrapper);
    }

    @Override
    public boolean deleteSurplusSteps(Long dagId, List<String> stepIds) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(DagConfigStep.class).eq(DagConfigStep::getDagId, (Object)dagId)).notIn(!CollectionUtils.isEmpty(stepIds), DagConfigStep::getStepId, stepIds);
        return this.remove((Wrapper)updateWrapper);
    }

    @Override
    public int clone(Long sourceDagId, Long targetDagId) {
        List<DagConfigStepDTO> sourceSteps = this.listSteps(sourceDagId);
        sourceSteps.forEach(stepDTO -> {
            stepDTO.setDagId(targetDagId);
            stepDTO.setId(null);
            stepDTO.setCreator(null);
            stepDTO.setCreateTime(null);
            stepDTO.setEditor(null);
            stepDTO.setUpdateTime(null);
            this.add((DagConfigStepDTO)((Object)stepDTO));
        });
        return sourceSteps.size();
    }
}

