/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.dag.service.impl;

import cn.sliew.carp.framework.common.util.UUIDUtil;
import cn.sliew.carp.framework.dag.repository.entity.DagInstance;
import cn.sliew.carp.framework.dag.repository.mapper.DagInstanceMapper;
import cn.sliew.carp.framework.dag.service.DagInstanceService;
import cn.sliew.carp.framework.dag.service.convert.DagInstanceConvert;
import cn.sliew.carp.framework.dag.service.dto.DagInstanceDTO;
import cn.sliew.carp.framework.mybatis.entity.BaseDO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DagInstanceServiceImpl
extends ServiceImpl<DagInstanceMapper, DagInstance>
implements DagInstanceService {
    @Override
    public DagInstanceDTO get(Long id) {
        DagInstance entity = (DagInstance)((Object)this.getOptById(id).orElseThrow(() -> new IllegalArgumentException("dag instance not exists for id: " + id)));
        return DagInstanceConvert.INSTANCE.toDto(entity);
    }

    @Override
    public Long add(DagInstanceDTO instanceDTO) {
        DagInstance record = DagInstanceConvert.INSTANCE.toDo(instanceDTO);
        record.setUuid(UUIDUtil.randomUUId());
        this.save((Object)record);
        return record.getId();
    }

    @Override
    public boolean update(DagInstanceDTO instanceDTO) {
        DagInstance record = DagInstanceConvert.INSTANCE.toDo(instanceDTO);
        return this.updateById((Object)record);
    }

    @Override
    public boolean updateStatus(Long id, String fromStatus, String toStatus) {
        LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(DagInstance.class).eq(BaseDO::getId, (Object)id)).eq(StringUtils.hasText((String)fromStatus), DagInstance::getStatus, (Object)fromStatus)).set(DagInstance::getStatus, (Object)toStatus);
        return this.update((Wrapper)wrapper);
    }
}

