/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.workflow.internal.engine.dispatch.handler.workflow;

import cn.sliew.carp.framework.common.dict.workflow.WorkflowInstanceEvent;
import cn.sliew.carp.framework.common.dict.workflow.WorkflowInstanceState;
import cn.sliew.carp.framework.dag.service.DagInstanceService;
import cn.sliew.carp.framework.dag.service.dto.DagInstanceDTO;
import cn.sliew.carp.module.workflow.internal.engine.dispatch.event.WorkflowInstanceEventDTO;
import cn.sliew.carp.module.workflow.internal.engine.dispatch.handler.workflow.AbstractWorkflowInstanceEventListener;
import java.io.Serializable;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowInstanceFailureEventListener
extends AbstractWorkflowInstanceEventListener {
    @Autowired
    private DagInstanceService dagInstanceService;

    public WorkflowInstanceEvent getType() {
        return WorkflowInstanceEvent.PROCESS_FAILURE;
    }

    @Override
    protected CompletableFuture handleEventAsync(WorkflowInstanceEventDTO event) {
        return CompletableFuture.runAsync(new FailureRunner(event.getWorkflowInstanceId(), event.getThrowable()));
    }

    private class FailureRunner
    implements Runnable,
    Serializable {
        private Long workflowInstanceId;
        private Optional<Throwable> throwable;

        public FailureRunner(Long workflowInstanceId, Throwable throwable) {
            this.workflowInstanceId = workflowInstanceId;
            this.throwable = Optional.ofNullable(throwable);
        }

        @Override
        public void run() {
            DagInstanceDTO dagInstanceUpdateParam = new DagInstanceDTO();
            dagInstanceUpdateParam.setId(this.workflowInstanceId);
            dagInstanceUpdateParam.setStatus(WorkflowInstanceState.FAILURE.getValue());
            dagInstanceUpdateParam.setEndTime(new Date());
            WorkflowInstanceFailureEventListener.this.dagInstanceService.update(dagInstanceUpdateParam);
        }
    }
}

