/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.workflow.internal.service.impl;

import cn.sliew.carp.framework.common.dict.workflow.WorkflowInstanceState;
import cn.sliew.carp.framework.common.dict.workflow.WorkflowStepType;
import cn.sliew.carp.framework.common.dict.workflow.WorkflowTaskInstanceStage;
import cn.sliew.carp.framework.dag.service.DagConfigLinkService;
import cn.sliew.carp.framework.dag.service.DagInstanceComplexService;
import cn.sliew.carp.framework.dag.service.DagInstanceService;
import cn.sliew.carp.framework.dag.service.DagStepService;
import cn.sliew.carp.framework.dag.service.dto.DagInstanceComplexDTO;
import cn.sliew.carp.framework.dag.service.dto.DagInstanceDTO;
import cn.sliew.carp.framework.dag.service.dto.DagStepDTO;
import cn.sliew.carp.module.workflow.api.engine.domain.instance.WorkflowExecutionGraph;
import cn.sliew.carp.module.workflow.api.engine.domain.instance.WorkflowInstance;
import cn.sliew.carp.module.workflow.api.engine.domain.instance.WorkflowTaskInstance;
import cn.sliew.carp.module.workflow.api.manager.WorkflowInstanceManager;
import cn.sliew.carp.module.workflow.api.service.WorkflowInstanceService;
import cn.sliew.carp.module.workflow.api.service.convert.WorkflowDefinitionGraphEdgeConvert;
import cn.sliew.carp.module.workflow.api.service.convert.WorkflowInstanceConvert;
import cn.sliew.carp.module.workflow.api.service.convert.WorkflowTaskInstanceConvert;
import cn.sliew.carp.module.workflow.api.service.param.WorkflowRunParam;
import cn.sliew.carp.module.workflow.api.service.param.WorkflowStopParam;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowInstanceServiceImpl
implements WorkflowInstanceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowInstanceServiceImpl.class);
    @Autowired
    private DagInstanceComplexService dagInstanceComplexService;
    @Autowired
    private DagInstanceService dagInstanceService;
    @Autowired
    private DagConfigLinkService dagConfigLinkService;
    @Autowired
    private DagStepService dagStepService;
    @Autowired
    private WorkflowInstanceManager workflowInstanceManager;

    public WorkflowInstance get(Long workflowInstanceId) {
        DagInstanceDTO dagInstanceDTO = this.dagInstanceComplexService.selectSimpleOne(workflowInstanceId);
        return WorkflowInstanceConvert.INSTANCE.toDto(dagInstanceDTO);
    }

    public WorkflowInstance getGraph(Long workflowInstanceId) {
        DagInstanceComplexDTO complexDTO = this.dagInstanceComplexService.selectOne(workflowInstanceId);
        WorkflowInstance dto = WorkflowInstanceConvert.INSTANCE.toDto((DagInstanceDTO)complexDTO);
        WorkflowExecutionGraph graph = new WorkflowExecutionGraph();
        dto.setGraph(graph);
        List allNodes = WorkflowTaskInstanceConvert.INSTANCE.toDto(complexDTO.getSteps());
        WorkflowTaskInstance preNode = allNodes.stream().filter(node -> node.getNode().getMeta().getStepType() == WorkflowStepType.PRE).findFirst().orElse(null);
        WorkflowTaskInstance postNode = allNodes.stream().filter(node -> node.getNode().getMeta().getStepType() == WorkflowStepType.POST).findFirst().orElse(null);
        List normalNodes = allNodes.stream().filter(node -> node.getNode().getMeta().getStepType() == WorkflowStepType.NORMAL).collect(Collectors.toList());
        graph.setPreTask(preNode);
        graph.setPostTask(postNode);
        graph.setTasks(normalNodes);
        List linkDTOS = this.dagConfigLinkService.listLinks(complexDTO.getDagConfig().getId());
        graph.setEdges(WorkflowDefinitionGraphEdgeConvert.INSTANCE.toDto(linkDTOS));
        return dto;
    }

    public WorkflowTaskInstance getTask(Long workflowTaskInstanceId) {
        DagStepDTO dagStepDTO = this.dagStepService.get(workflowTaskInstanceId);
        return WorkflowTaskInstanceConvert.INSTANCE.toDto(dagStepDTO);
    }

    public Long simpleInitialize(Long workflowDefinitionId) {
        Long workflowInstanceId = this.dagInstanceComplexService.initialize(workflowDefinitionId);
        this.dagInstanceService.updateStatus(workflowInstanceId, null, WorkflowInstanceState.PENDING.getValue());
        List dagStepDTOS = this.dagStepService.listSteps(workflowInstanceId);
        for (DagStepDTO dagStepDTO : dagStepDTOS) {
            this.dagStepService.updateStatus(dagStepDTO.getId(), null, WorkflowTaskInstanceStage.PENDING.getValue());
        }
        return workflowInstanceId;
    }

    public Long run(WorkflowRunParam param) {
        Long workflowInstanceId = this.simpleInitialize(param.getId());
        DagInstanceDTO instanceDTO = new DagInstanceDTO();
        instanceDTO.setId(workflowInstanceId);
        instanceDTO.setInputs(param.getGlobalVariable());
        this.dagInstanceService.update(instanceDTO);
        this.workflowInstanceManager.deploy(workflowInstanceId);
        return workflowInstanceId;
    }

    public void stop(WorkflowStopParam param) {
    }
}

