/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.workflow.api.service.convert;

import cn.sliew.carp.framework.common.convert.BaseConvert;
import cn.sliew.carp.framework.dag.algorithm.DAG;
import cn.sliew.carp.module.workflow.api.engine.domain.definition.WorkflowDefinitionGraphEdge;
import cn.sliew.carp.module.workflow.api.engine.domain.instance.WorkflowExecutionGraph;
import cn.sliew.carp.module.workflow.api.engine.domain.instance.WorkflowTaskInstance;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Set;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE)
public interface WorkflowExecutionGraphConvert
extends BaseConvert<WorkflowExecutionGraph, DAG<WorkflowTaskInstance>> {
    public static final WorkflowExecutionGraphConvert INSTANCE = (WorkflowExecutionGraphConvert)Mappers.getMapper(WorkflowExecutionGraphConvert.class);

    default public WorkflowExecutionGraph toDo(DAG<WorkflowTaskInstance> dag) {
        throw new UnsupportedOperationException();
    }

    default public DAG<WorkflowTaskInstance> toDto(WorkflowExecutionGraph graph) {
        DAG dag = new DAG();
        HashMap taskInstanceMap = Maps.newHashMap();
        for (WorkflowTaskInstance taskInstance : graph.getTasks()) {
            taskInstanceMap.put(taskInstance.getNode().getStepId(), taskInstance);
            dag.addNode((Object)taskInstance);
        }
        for (WorkflowDefinitionGraphEdge edge : graph.getEdges()) {
            dag.addEdge((Object)((WorkflowTaskInstance)((Object)taskInstanceMap.get(edge.getFromStepId()))), (Object)((WorkflowTaskInstance)((Object)taskInstanceMap.get(edge.getToStepId()))));
        }
        if (graph.getPreTask() != null) {
            dag.addNode((Object)graph.getPreTask());
            Set sources = dag.getSources();
            for (WorkflowTaskInstance source : sources) {
                dag.addEdge((Object)graph.getPreTask(), (Object)source);
            }
        }
        if (graph.getPostTask() != null) {
            dag.addNode((Object)graph.getPostTask());
            Set sinks = dag.getSinks();
            for (WorkflowTaskInstance sink : sinks) {
                dag.addEdge((Object)sink, (Object)graph.getPostTask());
            }
        }
        return dag;
    }
}

