/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.workflow.api.service.impl;

import cn.sliew.carp.framework.common.dict.workflow.WorkflowStepType;
import cn.sliew.carp.framework.dag.service.DagConfigComplexService;
import cn.sliew.carp.framework.dag.service.dto.DagConfigComplexDTO;
import cn.sliew.carp.framework.dag.service.dto.DagConfigDTO;
import cn.sliew.carp.module.workflow.api.engine.domain.definition.WorkflowDefinition;
import cn.sliew.carp.module.workflow.api.engine.domain.definition.WorkflowDefinitionGraph;
import cn.sliew.carp.module.workflow.api.engine.domain.definition.WorkflowDefinitionGraphNode;
import cn.sliew.carp.module.workflow.api.service.WorkflowDefinitionService;
import cn.sliew.carp.module.workflow.api.service.convert.WorkflowDefinitionConvert;
import cn.sliew.carp.module.workflow.api.service.convert.WorkflowDefinitionGraphEdgeConvert;
import cn.sliew.carp.module.workflow.api.service.convert.WorkflowDefinitionGraphNodeConvert;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowDefinitionServiceImpl
implements WorkflowDefinitionService {
    @Autowired
    private DagConfigComplexService dagConfigComplexService;

    @Override
    public WorkflowDefinition get(Long id) {
        DagConfigDTO dagConfigDTO = this.dagConfigComplexService.selectSimpleOne(id);
        return WorkflowDefinitionConvert.INSTANCE.toDto(dagConfigDTO);
    }

    @Override
    public WorkflowDefinition getGraph(Long id) {
        DagConfigComplexDTO complexDTO = this.dagConfigComplexService.selectOne(id);
        WorkflowDefinition dto = WorkflowDefinitionConvert.INSTANCE.toDto((DagConfigDTO)complexDTO);
        WorkflowDefinitionGraph graph = new WorkflowDefinitionGraph();
        dto.setGraph(graph);
        List edges = WorkflowDefinitionGraphEdgeConvert.INSTANCE.toDto(complexDTO.getLinks());
        List allNodes = WorkflowDefinitionGraphNodeConvert.INSTANCE.toDto(complexDTO.getSteps());
        WorkflowDefinitionGraphNode preNode = allNodes.stream().filter(node -> node.getMeta().getStepType() == WorkflowStepType.PRE).findFirst().orElse(null);
        WorkflowDefinitionGraphNode postNode = allNodes.stream().filter(node -> node.getMeta().getStepType() == WorkflowStepType.POST).findFirst().orElse(null);
        List<WorkflowDefinitionGraphNode> normalNodes = allNodes.stream().filter(node -> node.getMeta().getStepType() == WorkflowStepType.NORMAL).collect(Collectors.toList());
        graph.setEdges(edges);
        graph.setPreNode(preNode);
        graph.setPostNode(postNode);
        graph.setNodes(normalNodes);
        return dto;
    }
}

