/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.scheduler.api.executor;

import cn.hutool.core.bean.BeanUtil;
import cn.sliew.carp.module.scheduler.api.executor.JobContext;
import cn.sliew.carp.module.scheduler.api.executor.JobExecutor;
import cn.sliew.carp.module.scheduler.api.executor.JobHandler;
import cn.sliew.carp.module.scheduler.api.executor.JobHandlerFactory;
import cn.sliew.carp.module.scheduler.api.executor.JobHandlerFactoryRegistry;
import cn.sliew.carp.module.scheduler.api.executor.JobThread;
import cn.sliew.carp.module.scheduler.api.executor.JobThreadRepository;
import cn.sliew.carp.module.scheduler.api.executor.entity.ScheduleResponse;
import cn.sliew.carp.module.scheduler.api.executor.entity.job.JobExecutionResult;
import cn.sliew.carp.module.scheduler.api.executor.entity.trigger.TriggerParam;
import cn.sliew.milky.common.exception.Rethrower;
import java.util.concurrent.CompletableFuture;

public class DefaultJobExecutor
implements JobExecutor {
    private JobHandlerFactoryRegistry jobHandlerFactoryRegistry;
    private JobThreadRepository jobThreadRepository;

    public DefaultJobExecutor(JobHandlerFactoryRegistry jobHandlerFactoryRegistry, JobThreadRepository jobThreadRepository) {
        this.jobHandlerFactoryRegistry = jobHandlerFactoryRegistry;
        this.jobThreadRepository = jobThreadRepository;
    }

    @Override
    public ScheduleResponse execute(TriggerParam param) {
        if (!this.jobHandlerFactoryRegistry.exist(param.getJobType())) {
            return new ScheduleResponse("-1", "unknown job type: " + param.getJobType());
        }
        JobHandlerFactory jobHandlerFactory = (JobHandlerFactory)this.jobHandlerFactoryRegistry.find(param.getJobType()).get();
        JobHandler jobHandler = jobHandlerFactory.newInstance(param.getJobHandler());
        JobContext context = (JobContext)BeanUtil.copyProperties((Object)param, JobContext.class, (String[])new String[0]);
        JobThread jobThread = new JobThread(jobHandler, context);
        this.jobThreadRepository.save(jobThread);
        CompletableFuture.supplyAsync(() -> {
            try {
                return (JobExecutionResult)jobThread.call();
            }
            catch (Exception e) {
                Rethrower.throwAs((Throwable)e);
                return null;
            }
        }).whenComplete((result, throwable) -> this.jobThreadRepository.remove(jobThread.getJobId(), jobThread.getJobInstanceId()));
        return ScheduleResponse.SUCCESS;
    }
}

